rule win_sword_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sword."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sword"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 897c242c 8b3d???????? 6800010000 c74424143c000000 c744242064924000 89542424 }
            // n = 6, score = 100
            //   897c242c             | mov                 dword ptr [esp + 0x2c], edi
            //   8b3d????????         |                     
            //   6800010000           | push                0x100
            //   c74424143c000000     | mov                 dword ptr [esp + 0x14], 0x3c
            //   c744242064924000     | mov                 dword ptr [esp + 0x20], 0x409264
            //   89542424             | mov                 dword ptr [esp + 0x24], edx

        $sequence_1 = { f2ae f7d1 49 8d842488020000 51 50 56 }
            // n = 7, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   8d842488020000       | lea                 eax, [esp + 0x288]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_2 = { 8bfd 83c9ff 33c0 f2ae 8b542424 33db f7d1 }
            // n = 7, score = 100
            //   8bfd                 | mov                 edi, ebp
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]
            //   33db                 | xor                 ebx, ebx
            //   f7d1                 | not                 ecx

        $sequence_3 = { e8???????? 83c404 50 ff15???????? 668944240a 8d842428040000 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   668944240a           | mov                 word ptr [esp + 0xa], ax
            //   8d842428040000       | lea                 eax, [esp + 0x428]
            //   50                   | push                eax

        $sequence_4 = { 7c85 5f 5e 5d b801000000 5b 83c40c }
            // n = 7, score = 100
            //   7c85                 | jl                  0xffffff87
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { 8d8c2498060000 51 52 e8???????? 83c40c 8d842474020000 }
            // n = 6, score = 100
            //   8d8c2498060000       | lea                 ecx, [esp + 0x698]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d842474020000       | lea                 eax, [esp + 0x274]

        $sequence_6 = { 8d942488030000 f2ae f7d1 2bf9 53 8bf7 8bfa }
            // n = 7, score = 100
            //   8d942488030000       | lea                 edx, [esp + 0x388]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   53                   | push                ebx
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx

        $sequence_7 = { 52 e8???????? 8818 8d842490020000 }
            // n = 4, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   8818                 | mov                 byte ptr [eax], bl
            //   8d842490020000       | lea                 eax, [esp + 0x290]

        $sequence_8 = { 6a00 6a00 6a00 7509 8d542414 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   7509                 | jne                 0xb
            //   8d542414             | lea                 edx, [esp + 0x14]

        $sequence_9 = { 8d3c8d00a14000 c1e603 8b0f f644310401 7456 50 e8???????? }
            // n = 7, score = 100
            //   8d3c8d00a14000       | lea                 edi, [ecx*4 + 0x40a100]
            //   c1e603               | shl                 esi, 3
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   f644310401           | test                byte ptr [ecx + esi + 4], 1
            //   7456                 | je                  0x58
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 106496
}