rule win_sys10_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sys10."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sys10"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ffd7 8b4b08 51 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8b4b08               | mov                 ecx, dword ptr [ebx + 8]
            //   51                   | push                ecx

        $sequence_1 = { 7511 6810270000 ff15???????? 33c0 }
            // n = 4, score = 200
            //   7511                 | jne                 0x13
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { ffd3 6a00 6a00 6a00 6a00 8bf8 }
            // n = 6, score = 200
            //   ffd3                 | call                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8bf8                 | mov                 edi, eax

        $sequence_3 = { 7407 53 ff15???????? 8b06 50 }
            // n = 5, score = 200
            //   7407                 | je                  9
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   50                   | push                eax

        $sequence_4 = { 53 52 e8???????? 83c42c 85c0 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c42c               | add                 esp, 0x2c
            //   85c0                 | test                eax, eax

        $sequence_5 = { ffd7 8b4304 50 ffd7 8b4b08 51 }
            // n = 6, score = 200
            //   ffd7                 | call                edi
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8b4b08               | mov                 ecx, dword ptr [ebx + 8]
            //   51                   | push                ecx

        $sequence_6 = { 52 ffd7 8b4308 50 }
            // n = 4, score = 200
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   50                   | push                eax

        $sequence_7 = { 57 8d542438 53 52 e8???????? }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8d542438             | lea                 edx, [esp + 0x38]
            //   53                   | push                ebx
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_8 = { 6a00 897c2434 894c242c 89742438 }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   897c2434             | mov                 dword ptr [esp + 0x34], edi
            //   894c242c             | mov                 dword ptr [esp + 0x2c], ecx
            //   89742438             | mov                 dword ptr [esp + 0x38], esi

        $sequence_9 = { 52 6a05 50 ffd6 8b5308 }
            // n = 5, score = 200
            //   52                   | push                edx
            //   6a05                 | push                5
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b5308               | mov                 edx, dword ptr [ebx + 8]

    condition:
        7 of them and filesize < 286720
}