rule win_syscon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.syscon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.syscon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c4 898424d80b0000 53 56 }
            // n = 4, score = 200
            //   33c4                 | xor                 eax, esp
            //   898424d80b0000       | mov                 dword ptr [esp + 0xbd8], eax
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_1 = { 47 83c604 897df8 80fb40 7412 8a55ff }
            // n = 6, score = 200
            //   47                   | inc                 edi
            //   83c604               | add                 esi, 4
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   80fb40               | cmp                 bl, 0x40
            //   7412                 | je                  0x14
            //   8a55ff               | mov                 dl, byte ptr [ebp - 1]

        $sequence_2 = { 8d942414040000 68???????? 52 ff15???????? 83c40c 6a00 }
            // n = 6, score = 200
            //   8d942414040000       | lea                 edx, [esp + 0x414]
            //   68????????           |                     
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0

        $sequence_3 = { 57 8bc6 e8???????? 83c408 56 }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   56                   | push                esi

        $sequence_4 = { 68e8030000 ffd6 6a00 6a20 6a03 }
            // n = 5, score = 200
            //   68e8030000           | push                0x3e8
            //   ffd6                 | call                esi
            //   6a00                 | push                0
            //   6a20                 | push                0x20
            //   6a03                 | push                3

        $sequence_5 = { a1???????? 68???????? 50 ff15???????? 85c0 0f846affffff }
            // n = 6, score = 200
            //   a1????????           |                     
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f846affffff         | je                  0xffffff70

        $sequence_6 = { ff15???????? e9???????? 8b8c24e40b0000 5f }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8b8c24e40b0000       | mov                 ecx, dword ptr [esp + 0xbe4]
            //   5f                   | pop                 edi

        $sequence_7 = { eb0c 53 68???????? ff15???????? 57 }
            // n = 5, score = 200
            //   eb0c                 | jmp                 0xe
            //   53                   | push                ebx
            //   68????????           |                     
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_8 = { 488d5590 488d0daa300000 448bc0 e8???????? 488d8d20040000 }
            // n = 5, score = 100
            //   488d5590             | lea                 ecx, [ebp + 0x160]
            //   488d0daa300000       | dec                 eax
            //   448bc0               | lea                 ecx, [ebp + 0x160]
            //   e8????????           |                     
            //   488d8d20040000       | dec                 eax

        $sequence_9 = { e8???????? 488d0dab460000 ff15???????? 488d542420 488d0d99460000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488d0dab460000       | dec                 eax
            //   ff15????????         |                     
            //   488d542420           | lea                 ecx, [0x46ab]
            //   488d0d99460000       | dec                 eax

        $sequence_10 = { 498bcc ff15???????? 488bcf ff15???????? bf04010000 }
            // n = 5, score = 100
            //   498bcc               | lea                 ecx, [esp + 0x40]
            //   ff15????????         |                     
            //   488bcf               | inc                 esp
            //   ff15????????         |                     
            //   bf04010000           | mov                 eax, ebx

        $sequence_11 = { 488d4c2440 448bc3 33d2 e8???????? 488d542440 b904010000 ff15???????? }
            // n = 7, score = 100
            //   488d4c2440           | dec                 eax
            //   448bc3               | lea                 edx, [0x2f9e]
            //   33d2                 | dec                 eax
            //   e8????????           |                     
            //   488d542440           | lea                 edx, [ebp + 0x590]
            //   b904010000           | dec                 eax
            //   ff15????????         |                     

        $sequence_12 = { 488d8d90050000 488d159e2f0000 ff15???????? 488d9590050000 488d8d60010000 e8???????? 488d8d60010000 }
            // n = 7, score = 100
            //   488d8d90050000       | lea                 edx, [esp + 0x20]
            //   488d159e2f0000       | dec                 eax
            //   ff15????????         |                     
            //   488d9590050000       | lea                 ecx, [0x4699]
            //   488d8d60010000       | dec                 eax
            //   e8????????           |                     
            //   488d8d60010000       | lea                 ecx, [ebp + 0x590]

        $sequence_13 = { c705????????02000000 83f901 750a c705????????01000000 890d???????? 488b0d???????? 8915???????? }
            // n = 7, score = 100
            //   c705????????02000000     |     
            //   83f901               | mov                 ecx, 0x104
            //   750a                 | dec                 eax
            //   c705????????01000000     |     
            //   890d????????         |                     
            //   488b0d????????       |                     
            //   8915????????         |                     

        $sequence_14 = { 488d0d07460000 448bc0 e8???????? 488d542420 }
            // n = 4, score = 100
            //   488d0d07460000       | xor                 edx, edx
            //   448bc0               | dec                 eax
            //   e8????????           |                     
            //   488d542420           | lea                 edx, [esp + 0x40]

        $sequence_15 = { 89542420 4c8d442450 488d8d90050000 488d1514310000 }
            // n = 4, score = 100
            //   89542420             | lea                 edx, [ebp - 0x70]
            //   4c8d442450           | dec                 eax
            //   488d8d90050000       | lea                 ecx, [0x30aa]
            //   488d1514310000       | inc                 esp

    condition:
        7 of them and filesize < 120832
}