rule win_sysget_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sysget."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sysget"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? bf???????? 83c424 c60000 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   bf????????           |                     
            //   83c424               | add                 esp, 0x24
            //   c60000               | mov                 byte ptr [eax], 0

        $sequence_1 = { 668b08 83c002 6685c9 75f5 8dbdecf1ffff 2bc6 83ef02 }
            // n = 7, score = 400
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   8dbdecf1ffff         | lea                 edi, [ebp - 0xe14]
            //   2bc6                 | sub                 eax, esi
            //   83ef02               | sub                 edi, 2

        $sequence_2 = { 8325????????00 5e c3 55 8bec 83ec34 a1???????? }
            // n = 7, score = 400
            //   8325????????00       |                     
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec34               | sub                 esp, 0x34
            //   a1????????           |                     

        $sequence_3 = { 8985c4f9ffff 052c010000 50 e8???????? 83c40c 6800800000 }
            // n = 6, score = 400
            //   8985c4f9ffff         | mov                 dword ptr [ebp - 0x63c], eax
            //   052c010000           | add                 eax, 0x12c
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6800800000           | push                0x8000

        $sequence_4 = { a3???????? 57 6a11 59 6a7c 8d4580 }
            // n = 6, score = 400
            //   a3????????           |                     
            //   57                   | push                edi
            //   6a11                 | push                0x11
            //   59                   | pop                 ecx
            //   6a7c                 | push                0x7c
            //   8d4580               | lea                 eax, [ebp - 0x80]

        $sequence_5 = { 8d85fcf7ffff 50 e8???????? 59 33c0 }
            // n = 5, score = 400
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 8b85f8fbffff 8d8df4fbffff 51 50 8d85fcfbffff }
            // n = 5, score = 400
            //   8b85f8fbffff         | mov                 eax, dword ptr [ebp - 0x408]
            //   8d8df4fbffff         | lea                 ecx, [ebp - 0x40c]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]

        $sequence_7 = { 8b35???????? 57 6a10 58 50 6a01 }
            // n = 6, score = 400
            //   8b35????????         |                     
            //   57                   | push                edi
            //   6a10                 | push                0x10
            //   58                   | pop                 eax
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_8 = { ff15???????? 8bc6 8bd6 668b08 83c002 663bcb }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   8bd6                 | mov                 edx, esi
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2
            //   663bcb               | cmp                 cx, bx

        $sequence_9 = { 8d853cffffff 50 ff35???????? ff15???????? a1???????? }
            // n = 5, score = 400
            //   8d853cffffff         | lea                 eax, [ebp - 0xc4]
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   a1????????           |                     

    condition:
        7 of them and filesize < 352256
}