rule win_sysjoker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sysjoker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sysjoker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4f24 3b4f18 0f83ad060000 8b4714 46 891488 e9???????? }
            // n = 7, score = 100
            //   8b4f24               | mov                 ecx, dword ptr [edi + 0x24]
            //   3b4f18               | cmp                 ecx, dword ptr [edi + 0x18]
            //   0f83ad060000         | jae                 0x6b3
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]
            //   46                   | inc                 esi
            //   891488               | mov                 dword ptr [eax + ecx*4], edx
            //   e9????????           |                     

        $sequence_1 = { c745d40f000000 c645c000 c78564ffffff90a34400 e8???????? 8d8558ffffff c78554ffffff90a34400 50 }
            // n = 7, score = 100
            //   c745d40f000000       | mov                 dword ptr [ebp - 0x2c], 0xf
            //   c645c000             | mov                 byte ptr [ebp - 0x40], 0
            //   c78564ffffff90a34400     | mov    dword ptr [ebp - 0x9c], 0x44a390
            //   e8????????           |                     
            //   8d8558ffffff         | lea                 eax, [ebp - 0xa8]
            //   c78554ffffff90a34400     | mov    dword ptr [ebp - 0xac], 0x44a390
            //   50                   | push                eax

        $sequence_2 = { c78500fdffff00000000 33f6 8b3d???????? 89bde0fcffff 0f1f8000000000 }
            // n = 5, score = 100
            //   c78500fdffff00000000     | mov    dword ptr [ebp - 0x300], 0
            //   33f6                 | xor                 esi, esi
            //   8b3d????????         |                     
            //   89bde0fcffff         | mov                 dword ptr [ebp - 0x320], edi
            //   0f1f8000000000       | nop                 dword ptr [eax]

        $sequence_3 = { 0f837a100000 8b8fd8000000 85c9 742f 83bfdc00000008 8d87c8000000 }
            // n = 6, score = 100
            //   0f837a100000         | jae                 0x1080
            //   8b8fd8000000         | mov                 ecx, dword ptr [edi + 0xd8]
            //   85c9                 | test                ecx, ecx
            //   742f                 | je                  0x31
            //   83bfdc00000008       | cmp                 dword ptr [edi + 0xdc], 8
            //   8d87c8000000         | lea                 eax, [edi + 0xc8]

        $sequence_4 = { 0f84aafeffff 8b8d6cffffff 2bca 8bc2 83e1fc 81f900100000 }
            // n = 6, score = 100
            //   0f84aafeffff         | je                  0xfffffeb0
            //   8b8d6cffffff         | mov                 ecx, dword ptr [ebp - 0x94]
            //   2bca                 | sub                 ecx, edx
            //   8bc2                 | mov                 eax, edx
            //   83e1fc               | and                 ecx, 0xfffffffc
            //   81f900100000         | cmp                 ecx, 0x1000

        $sequence_5 = { e8???????? 8b45ec 80780d00 74ae 3975dc 0f845e010000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   80780d00             | cmp                 byte ptr [eax + 0xd], 0
            //   74ae                 | je                  0xffffffb0
            //   3975dc               | cmp                 dword ptr [ebp - 0x24], esi
            //   0f845e010000         | je                  0x164

        $sequence_6 = { 8901 51 8bcc c645fc2a 68???????? e8???????? 8d4dc8 }
            // n = 7, score = 100
            //   8901                 | mov                 dword ptr [ecx], eax
            //   51                   | push                ecx
            //   8bcc                 | mov                 ecx, esp
            //   c645fc2a             | mov                 byte ptr [ebp - 4], 0x2a
            //   68????????           |                     
            //   e8????????           |                     
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]

        $sequence_7 = { 0f8714010000 52 51 e8???????? 83c408 c645fc01 8b8d48feffff }
            // n = 7, score = 100
            //   0f8714010000         | ja                  0x11a
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b8d48feffff         | mov                 ecx, dword ptr [ebp - 0x1b8]

        $sequence_8 = { 52 8b01 ff5004 51 8bf4 89a5f4fcffff }
            // n = 6, score = 100
            //   52                   | push                edx
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5004               | call                dword ptr [eax + 4]
            //   51                   | push                ecx
            //   8bf4                 | mov                 esi, esp
            //   89a5f4fcffff         | mov                 dword ptr [ebp - 0x30c], esp

        $sequence_9 = { 8906 c645fc12 e8???????? 83c408 e8???????? 8bc8 85c9 }
            // n = 7, score = 100
            //   8906                 | mov                 dword ptr [esi], eax
            //   c645fc12             | mov                 byte ptr [ebp - 4], 0x12
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   85c9                 | test                ecx, ecx

    condition:
        7 of them and filesize < 832512
}