rule win_taintedscribe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.taintedscribe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.taintedscribe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcf 0facd110 c1fa10 0fb65330 }
            // n = 4, score = 500
            //   8bcf                 | mov                 ecx, edi
            //   0facd110             | shrd                ecx, edx, 0x10
            //   c1fa10               | sar                 edx, 0x10
            //   0fb65330             | movzx               edx, byte ptr [ebx + 0x30]

        $sequence_1 = { 5e 8be5 5d c20800 c7460c00000001 }
            // n = 5, score = 500
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   c7460c00000001       | mov                 dword ptr [esi + 0xc], 0x1000000

        $sequence_2 = { 8b5358 898d88fbffff 8b4b50 0f94c0 }
            // n = 4, score = 500
            //   8b5358               | mov                 edx, dword ptr [ebx + 0x58]
            //   898d88fbffff         | mov                 dword ptr [ebp - 0x478], ecx
            //   8b4b50               | mov                 ecx, dword ptr [ebx + 0x50]
            //   0f94c0               | sete                al

        $sequence_3 = { 8d5594 52 6a04 8d4590 50 56 }
            // n = 6, score = 500
            //   8d5594               | lea                 edx, [ebp - 0x6c]
            //   52                   | push                edx
            //   6a04                 | push                4
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_4 = { 8bd7 8b7b40 0facc218 c1f818 8a4340 }
            // n = 5, score = 500
            //   8bd7                 | mov                 edx, edi
            //   8b7b40               | mov                 edi, dword ptr [ebx + 0x40]
            //   0facc218             | shrd                edx, eax, 0x18
            //   c1f818               | sar                 eax, 0x18
            //   8a4340               | mov                 al, byte ptr [ebx + 0x40]

        $sequence_5 = { 8b4dcc 894308 8b45d0 50 }
            // n = 4, score = 500
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   894308               | mov                 dword ptr [ebx + 8], eax
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   50                   | push                eax

        $sequence_6 = { 5b 5d c20c00 83f803 7574 }
            // n = 5, score = 500
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   83f803               | cmp                 eax, 3
            //   7574                 | jne                 0x76

        $sequence_7 = { 898da8fbffff 8d45e8 8985b4fcffff 8b433c 8bd0 8d4ddc }
            // n = 6, score = 500
            //   898da8fbffff         | mov                 dword ptr [ebp - 0x458], ecx
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   8985b4fcffff         | mov                 dword ptr [ebp - 0x34c], eax
            //   8b433c               | mov                 eax, dword ptr [ebx + 0x3c]
            //   8bd0                 | mov                 edx, eax
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]

        $sequence_8 = { 6a00 6a00 ff15???????? 85c0 7516 }
            // n = 5, score = 500
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7516                 | jne                 0x18

        $sequence_9 = { bb01000000 d3e3 33c0 85db 7e1e 8d4900 }
            // n = 6, score = 500
            //   bb01000000           | mov                 ebx, 1
            //   d3e3                 | shl                 ebx, cl
            //   33c0                 | xor                 eax, eax
            //   85db                 | test                ebx, ebx
            //   7e1e                 | jle                 0x20
            //   8d4900               | lea                 ecx, [ecx]

    condition:
        7 of them and filesize < 524288
}