rule win_taleret_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.taleret."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.taleret"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89442430 8bf8 8bc1 8bf5 55 c1e902 f3a5 }
            // n = 7, score = 100
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   8bf8                 | mov                 edi, eax
            //   8bc1                 | mov                 eax, ecx
            //   8bf5                 | mov                 esi, ebp
            //   55                   | push                ebp
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_1 = { 85c0 741b 8b4c241c 51 ffd3 8b542410 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   741b                 | je                  0x1d
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   51                   | push                ecx
            //   ffd3                 | call                ebx
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]

        $sequence_2 = { 51 68???????? 52 e8???????? 50 8d4c2414 c644243802 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   c644243802           | mov                 byte ptr [esp + 0x38], 2

        $sequence_3 = { 8d4c242c c78424a8030000ffffffff e8???????? 56 e8???????? 83c404 8b7c2410 }
            // n = 7, score = 100
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   c78424a8030000ffffffff     | mov    dword ptr [esp + 0x3a8], 0xffffffff
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]

        $sequence_4 = { 85ff 896c2420 7e2a 8b4c2440 8d442420 }
            // n = 5, score = 100
            //   85ff                 | test                edi, edi
            //   896c2420             | mov                 dword ptr [esp + 0x20], ebp
            //   7e2a                 | jle                 0x2c
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   8d442420             | lea                 eax, [esp + 0x20]

        $sequence_5 = { 85c0 0f84a6000000 50 51 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   0f84a6000000         | je                  0xac
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_6 = { 50 e8???????? 8d8eb0010000 8d542434 51 68???????? 52 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8eb0010000         | lea                 ecx, [esi + 0x1b0]
            //   8d542434             | lea                 edx, [esp + 0x34]
            //   51                   | push                ecx
            //   68????????           |                     
            //   52                   | push                edx

        $sequence_7 = { 51 ffd6 85c0 7536 ff15???????? 83f87a }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7536                 | jne                 0x38
            //   ff15????????         |                     
            //   83f87a               | cmp                 eax, 0x7a

        $sequence_8 = { ff15???????? 8bd8 3bde 895c2420 750d 5f }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bde                 | cmp                 ebx, esi
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx
            //   750d                 | jne                 0xf
            //   5f                   | pop                 edi

        $sequence_9 = { 8b4c2424 c644310100 8d4c2430 e8???????? 50 }
            // n = 5, score = 100
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   c644310100           | mov                 byte ptr [ecx + esi + 1], 0
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     
            //   50                   | push                eax

    condition:
        7 of them and filesize < 73728
}