rule win_tandfuy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tandfuy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tandfuy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f2ae 8b442410 f7d1 49 51 8b4c2418 }
            // n = 6, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   51                   | push                ecx
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]

        $sequence_1 = { 33c0 b9000a0000 50 50 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   b9000a0000           | mov                 ecx, 0xa00
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_2 = { 50 e8???????? b93f000000 33c0 8dbdecfdffff f3ab 66ab }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   b93f000000           | mov                 ecx, 0x3f
            //   33c0                 | xor                 eax, eax
            //   8dbdecfdffff         | lea                 edi, [ebp - 0x214]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_3 = { ff15???????? 8bd8 85db 0f84be000000 8d4c2408 6a00 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   0f84be000000         | je                  0xc4
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   6a00                 | push                0

        $sequence_4 = { ff15???????? 50 ff15???????? 85c0 0f84ea000000 8d4c2424 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84ea000000         | je                  0xf0
            //   8d4c2424             | lea                 ecx, [esp + 0x24]

        $sequence_5 = { 33c0 c3 8b442408 50 ff15???????? }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_6 = { e8???????? 83c40c 85c0 766e }
            // n = 4, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   766e                 | jbe                 0x70

        $sequence_7 = { 33c0 f3a5 a4 b90a000000 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   b90a000000           | mov                 ecx, 0xa

        $sequence_8 = { 51 e8???????? 83c418 8bd0 8995d4faffff 8db5f0fcffff 8bfb }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8bd0                 | mov                 edx, eax
            //   8995d4faffff         | mov                 dword ptr [ebp - 0x52c], edx
            //   8db5f0fcffff         | lea                 esi, [ebp - 0x310]
            //   8bfb                 | mov                 edi, ebx

        $sequence_9 = { 6800000080 56 f3ab ff15???????? 8bd8 }
            // n = 5, score = 100
            //   6800000080           | push                0x80000000
            //   56                   | push                esi
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

    condition:
        7 of them and filesize < 155648
}