rule win_tapaoux_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tapaoux."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tapaoux"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 8d442418 68???????? 50 e8???????? 8b07 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_1 = { 8b4c243e 81e2ffff0000 25ffff0000 52 8b54243e 50 8b442440 }
            // n = 7, score = 100
            //   8b4c243e             | mov                 ecx, dword ptr [esp + 0x3e]
            //   81e2ffff0000         | and                 edx, 0xffff
            //   25ffff0000           | and                 eax, 0xffff
            //   52                   | push                edx
            //   8b54243e             | mov                 edx, dword ptr [esp + 0x3e]
            //   50                   | push                eax
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]

        $sequence_2 = { ff15???????? 8a842410050000 83c410 33db }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   8a842410050000       | mov                 al, byte ptr [esp + 0x510]
            //   83c410               | add                 esp, 0x10
            //   33db                 | xor                 ebx, ebx

        $sequence_3 = { 5b 81c408040000 c3 8b84241c040000 8b4b04 }
            // n = 5, score = 100
            //   5b                   | pop                 ebx
            //   81c408040000         | add                 esp, 0x408
            //   c3                   | ret                 
            //   8b84241c040000       | mov                 eax, dword ptr [esp + 0x41c]
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]

        $sequence_4 = { 83c40c 85c0 56 7d16 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   56                   | push                esi
            //   7d16                 | jge                 0x18

        $sequence_5 = { 8d442410 50 e8???????? 8b8c2428010000 83c404 }
            // n = 5, score = 100
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b8c2428010000       | mov                 ecx, dword ptr [esp + 0x128]
            //   83c404               | add                 esp, 4

        $sequence_6 = { 8b44241c 8d542410 52 8d8c24d8060000 50 51 57 }
            // n = 7, score = 100
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   52                   | push                edx
            //   8d8c24d8060000       | lea                 ecx, [esp + 0x6d8]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   57                   | push                edi

        $sequence_7 = { 83c410 85c0 7507 b850000000 eb09 50 e8???????? }
            // n = 7, score = 100
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   b850000000           | mov                 eax, 0x50
            //   eb09                 | jmp                 0xb
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 8be8 0fbe03 50 e8???????? 83c408 3bc5 }
            // n = 6, score = 100
            //   8be8                 | mov                 ebp, eax
            //   0fbe03               | movsx               eax, byte ptr [ebx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   3bc5                 | cmp                 eax, ebp

        $sequence_9 = { 84c0 74c5 3bf7 7ccf 5f 5e 5d }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   74c5                 | je                  0xffffffc7
            //   3bf7                 | cmp                 esi, edi
            //   7ccf                 | jl                  0xffffffd1
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 292864
}