rule win_targetcompany_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.targetcompany."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.targetcompany"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8955f4 e8???????? ff75b4 8bf8 53 }
            // n = 5, score = 500
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   e8????????           |                     
            //   ff75b4               | push                dword ptr [ebp - 0x4c]
            //   8bf8                 | mov                 edi, eax
            //   53                   | push                ebx

        $sequence_1 = { e8???????? 8d45b0 50 8d85c0feffff 50 8d8d10ffffff e8???????? }
            // n = 7, score = 500
            //   e8????????           |                     
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   50                   | push                eax
            //   8d85c0feffff         | lea                 eax, [ebp - 0x140]
            //   50                   | push                eax
            //   8d8d10ffffff         | lea                 ecx, [ebp - 0xf0]
            //   e8????????           |                     

        $sequence_2 = { 8bcf 83f808 7207 8b17 89550c eb03 897d0c }
            // n = 7, score = 500
            //   8bcf                 | mov                 ecx, edi
            //   83f808               | cmp                 eax, 8
            //   7207                 | jb                  9
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   89550c               | mov                 dword ptr [ebp + 0xc], edx
            //   eb03                 | jmp                 5
            //   897d0c               | mov                 dword ptr [ebp + 0xc], edi

        $sequence_3 = { 57 6a0f 5a 8bce 8d45e0 e8???????? }
            // n = 6, score = 500
            //   57                   | push                edi
            //   6a0f                 | push                0xf
            //   5a                   | pop                 edx
            //   8bce                 | mov                 ecx, esi
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   e8????????           |                     

        $sequence_4 = { 50 ff15???????? be08000100 56 8944242c 8d842430450000 53 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   ff15????????         |                     
            //   be08000100           | mov                 esi, 0x10008
            //   56                   | push                esi
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   8d842430450000       | lea                 eax, [esp + 0x4530]
            //   53                   | push                ebx

        $sequence_5 = { 53 895db0 8955b4 e8???????? ff75b4 8906 8b4708 }
            // n = 7, score = 500
            //   53                   | push                ebx
            //   895db0               | mov                 dword ptr [ebp - 0x50], ebx
            //   8955b4               | mov                 dword ptr [ebp - 0x4c], edx
            //   e8????????           |                     
            //   ff75b4               | push                dword ptr [ebp - 0x4c]
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b4708               | mov                 eax, dword ptr [edi + 8]

        $sequence_6 = { 0f85a0000000 56 50 68???????? e8???????? 83c40c 83bdbcfeffff20 }
            // n = 7, score = 500
            //   0f85a0000000         | jne                 0xa6
            //   56                   | push                esi
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   83bdbcfeffff20       | cmp                 dword ptr [ebp - 0x144], 0x20

        $sequence_7 = { 8945c0 8b75c0 8d7d9c a5 }
            // n = 4, score = 500
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   8b75c0               | mov                 esi, dword ptr [ebp - 0x40]
            //   8d7d9c               | lea                 edi, [ebp - 0x64]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_8 = { ab ab 53 53 ab 8b442424 6801200000 }
            // n = 7, score = 500
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   6801200000           | push                0x2001

        $sequence_9 = { 83fe50 72d0 8db564ffffff e8???????? }
            // n = 4, score = 500
            //   83fe50               | cmp                 esi, 0x50
            //   72d0                 | jb                  0xffffffd2
            //   8db564ffffff         | lea                 esi, [ebp - 0x9c]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 328704
}