rule win_tarsip_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tarsip."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tarsip"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895c2420 885c2410 6a25 68???????? 8d4c2414 899c243c010000 e8???????? }
            // n = 7, score = 100
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx
            //   885c2410             | mov                 byte ptr [esp + 0x10], bl
            //   6a25                 | push                0x25
            //   68????????           |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   899c243c010000       | mov                 dword ptr [esp + 0x13c], ebx
            //   e8????????           |                     

        $sequence_1 = { 53 68???????? 8d4c247c c78424940000000f000000 899c2490000000 889c2480000000 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   68????????           |                     
            //   8d4c247c             | lea                 ecx, [esp + 0x7c]
            //   c78424940000000f000000     | mov    dword ptr [esp + 0x94], 0xf
            //   899c2490000000       | mov                 dword ptr [esp + 0x90], ebx
            //   889c2480000000       | mov                 byte ptr [esp + 0x80], bl

        $sequence_2 = { b001 894c2410 88442414 0f85ff000000 8b742434 8b4614 8b4e18 }
            // n = 7, score = 100
            //   b001                 | mov                 al, 1
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   88442414             | mov                 byte ptr [esp + 0x14], al
            //   0f85ff000000         | jne                 0x105
            //   8b742434             | mov                 esi, dword ptr [esp + 0x34]
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   8b4e18               | mov                 ecx, dword ptr [esi + 0x18]

        $sequence_3 = { 7210 8b9424dc000000 52 e8???????? 83c404 84db 745c }
            // n = 7, score = 100
            //   7210                 | jb                  0x12
            //   8b9424dc000000       | mov                 edx, dword ptr [esp + 0xdc]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   84db                 | test                bl, bl
            //   745c                 | je                  0x5e

        $sequence_4 = { ff15???????? 5b 33c0 5e c3 57 6a00 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   5b                   | pop                 ebx
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_5 = { 885c2470 6a0e 68???????? 8d4c2474 899c24bc0e0000 e8???????? 68ff000000 }
            // n = 7, score = 100
            //   885c2470             | mov                 byte ptr [esp + 0x70], bl
            //   6a0e                 | push                0xe
            //   68????????           |                     
            //   8d4c2474             | lea                 ecx, [esp + 0x74]
            //   899c24bc0e0000       | mov                 dword ptr [esp + 0xebc], ebx
            //   e8????????           |                     
            //   68ff000000           | push                0xff

        $sequence_6 = { 51 c68424c801000000 e8???????? 8bbc248c000000 be10000000 83c40c 39b42494000000 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   c68424c801000000     | mov                 byte ptr [esp + 0x1c8], 0
            //   e8????????           |                     
            //   8bbc248c000000       | mov                 edi, dword ptr [esp + 0x8c]
            //   be10000000           | mov                 esi, 0x10
            //   83c40c               | add                 esp, 0xc
            //   39b42494000000       | cmp                 dword ptr [esp + 0x94], esi

        $sequence_7 = { 50 52 53 e8???????? 8b8690830000 8b08 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   52                   | push                edx
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b8690830000         | mov                 eax, dword ptr [esi + 0x8390]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_8 = { 8d44242c 50 8d4c242c 51 8d542424 52 ffd6 }
            // n = 7, score = 100
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   50                   | push                eax
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   51                   | push                ecx
            //   8d542424             | lea                 edx, [esp + 0x24]
            //   52                   | push                edx
            //   ffd6                 | call                esi

        $sequence_9 = { eb03 897e08 8b5118 392a 7520 807f4500 7404 }
            // n = 7, score = 100
            //   eb03                 | jmp                 5
            //   897e08               | mov                 dword ptr [esi + 8], edi
            //   8b5118               | mov                 edx, dword ptr [ecx + 0x18]
            //   392a                 | cmp                 dword ptr [edx], ebp
            //   7520                 | jne                 0x22
            //   807f4500             | cmp                 byte ptr [edi + 0x45], 0
            //   7404                 | je                  6

    condition:
        7 of them and filesize < 360448
}