rule win_taurus_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.taurus_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.taurus_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f9445d1 e8???????? 668945d2 8d4d94 8b45c4 8db778020000 3b45c8 }
            // n = 7, score = 200
            //   0f9445d1             | sete                byte ptr [ebp - 0x2f]
            //   e8????????           |                     
            //   668945d2             | mov                 word ptr [ebp - 0x2e], ax
            //   8d4d94               | lea                 ecx, [ebp - 0x6c]
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]
            //   8db778020000         | lea                 esi, [edi + 0x278]
            //   3b45c8               | cmp                 eax, dword ptr [ebp - 0x38]

        $sequence_1 = { 8d45d0 50 8d45f4 50 e8???????? 50 8d45b8 }
            // n = 7, score = 200
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d45b8               | lea                 eax, [ebp - 0x48]

        $sequence_2 = { 8bce e8???????? 8bd0 c745f829674844 b129 c745fc4c130900 33c0 }
            // n = 7, score = 200
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   c745f829674844       | mov                 dword ptr [ebp - 8], 0x44486729
            //   b129                 | mov                 cl, 0x29
            //   c745fc4c130900       | mov                 dword ptr [ebp - 4], 0x9134c
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 50 8d85c0feffff 50 8d4dcb e8???????? 8b85c4feffff 8d8d40ffffff }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d85c0feffff         | lea                 eax, [ebp - 0x140]
            //   50                   | push                eax
            //   8d4dcb               | lea                 ecx, [ebp - 0x35]
            //   e8????????           |                     
            //   8b85c4feffff         | mov                 eax, dword ptr [ebp - 0x13c]
            //   8d8d40ffffff         | lea                 ecx, [ebp - 0xc0]

        $sequence_4 = { 33c0 304c05ed 40 83f806 7305 8a4dec }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   304c05ed             | xor                 byte ptr [ebp + eax - 0x13], cl
            //   40                   | inc                 eax
            //   83f806               | cmp                 eax, 6
            //   7305                 | jae                 7
            //   8a4dec               | mov                 cl, byte ptr [ebp - 0x14]

        $sequence_5 = { e8???????? 8bd0 c744242f74271706 6a07 58 88442436 b174 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   c744242f74271706     | mov                 dword ptr [esp + 0x2f], 0x6172774
            //   6a07                 | push                7
            //   58                   | pop                 eax
            //   88442436             | mov                 byte ptr [esp + 0x36], al
            //   b174                 | mov                 cl, 0x74

        $sequence_6 = { f7c300200000 7414 81e3ffdfffff 8d8d04ffffff 895df8 e8???????? }
            // n = 6, score = 200
            //   f7c300200000         | test                ebx, 0x2000
            //   7414                 | je                  0x16
            //   81e3ffdfffff         | and                 ebx, 0xffffdfff
            //   8d8d04ffffff         | lea                 ecx, [ebp - 0xfc]
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   e8????????           |                     

        $sequence_7 = { 57 ffd0 8bf8 897d0c 83ffff 746f 8b9530ffffff }
            // n = 7, score = 200
            //   57                   | push                edi
            //   ffd0                 | call                eax
            //   8bf8                 | mov                 edi, eax
            //   897d0c               | mov                 dword ptr [ebp + 0xc], edi
            //   83ffff               | cmp                 edi, -1
            //   746f                 | je                  0x71
            //   8b9530ffffff         | mov                 edx, dword ptr [ebp - 0xd0]

        $sequence_8 = { c1fa06 8bc7 83e03f 6bc838 8b049578c14300 f644082801 7421 }
            // n = 7, score = 200
            //   c1fa06               | sar                 edx, 6
            //   8bc7                 | mov                 eax, edi
            //   83e03f               | and                 eax, 0x3f
            //   6bc838               | imul                ecx, eax, 0x38
            //   8b049578c14300       | mov                 eax, dword ptr [edx*4 + 0x43c178]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7421                 | je                  0x23

        $sequence_9 = { c74654c3280308 c7465881120d0e c7465ce58b8009 c74660d5208b07 c74664359ac202 c74668f19ad809 c7466ca13ba208 }
            // n = 7, score = 200
            //   c74654c3280308       | mov                 dword ptr [esi + 0x54], 0x80328c3
            //   c7465881120d0e       | mov                 dword ptr [esi + 0x58], 0xe0d1281
            //   c7465ce58b8009       | mov                 dword ptr [esi + 0x5c], 0x9808be5
            //   c74660d5208b07       | mov                 dword ptr [esi + 0x60], 0x78b20d5
            //   c74664359ac202       | mov                 dword ptr [esi + 0x64], 0x2c29a35
            //   c74668f19ad809       | mov                 dword ptr [esi + 0x68], 0x9d89af1
            //   c7466ca13ba208       | mov                 dword ptr [esi + 0x6c], 0x8a23ba1

    condition:
        7 of them and filesize < 524288
}