rule win_teledoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.teledoor"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 00b9c90200c5 7400 0006 00ce c9 0200 16 }
            // n = 7, score = 100
            //   00b9c90200c5         | add                 byte ptr [ecx - 0x3afffd37], bh
            //   7400                 | je                  2
            //   0006                 | add                 byte ptr [esi], al
            //   00ce                 | add                 dh, cl
            //   c9                   | leave               
            //   0200                 | add                 al, byte ptr [eax]
            //   16                   | push                ss

        $sequence_1 = { 00ce c9 0200 16 2800 001e 00fc }
            // n = 7, score = 100
            //   00ce                 | add                 dh, cl
            //   c9                   | leave               
            //   0200                 | add                 al, byte ptr [eax]
            //   16                   | push                ss
            //   2800                 | sub                 byte ptr [eax], al
            //   001e                 | add                 byte ptr [esi], bl
            //   00fc                 | add                 ah, bh

        $sequence_2 = { dec9 0200 1e 0073ca 0200 }
            // n = 5, score = 100
            //   dec9                 | fmulp               st(1)
            //   0200                 | add                 al, byte ptr [eax]
            //   1e                   | push                ds
            //   0073ca               | add                 byte ptr [ebx - 0x36], dh
            //   0200                 | add                 al, byte ptr [eax]

        $sequence_3 = { 98 0100 831001 007220 38c3 1400 }
            // n = 6, score = 100
            //   98                   | cwde                
            //   0100                 | add                 dword ptr [eax], eax
            //   831001               | adc                 dword ptr [eax], 1
            //   007220               | add                 byte ptr [edx + 0x20], dh
            //   38c3                 | cmp                 bl, al
            //   1400                 | adc                 al, 0

        $sequence_4 = { e601 e15c 0100 80fb00 }
            // n = 4, score = 100
            //   e601                 | out                 1, al
            //   e15c                 | loope               0x5e
            //   0100                 | add                 dword ptr [eax], eax
            //   80fb00               | cmp                 bl, 0

        $sequence_5 = { 015a5f 0100 e9???????? 1cd8 0913 0000 00e6 }
            // n = 7, score = 100
            //   015a5f               | add                 dword ptr [edx + 0x5f], ebx
            //   0100                 | add                 dword ptr [eax], eax
            //   e9????????           |                     
            //   1cd8                 | sbb                 al, 0xd8
            //   0913                 | or                  dword ptr [ebx], edx
            //   0000                 | add                 byte ptr [eax], al
            //   00e6                 | add                 dh, ah

        $sequence_6 = { c9 0200 16 2800 001e }
            // n = 5, score = 100
            //   c9                   | leave               
            //   0200                 | add                 al, byte ptr [eax]
            //   16                   | push                ss
            //   2800                 | sub                 byte ptr [eax], al
            //   001e                 | add                 byte ptr [esi], bl

        $sequence_7 = { 001e 00b9c90200c5 7400 0006 00ce c9 }
            // n = 6, score = 100
            //   001e                 | add                 byte ptr [esi], bl
            //   00b9c90200c5         | add                 byte ptr [ecx - 0x3afffd37], bh
            //   7400                 | je                  2
            //   0006                 | add                 byte ptr [esi], al
            //   00ce                 | add                 dh, cl
            //   c9                   | leave               

        $sequence_8 = { 3217 189e11327309 2000 0aa2112e1828 }
            // n = 4, score = 100
            //   3217                 | xor                 dl, byte ptr [edi]
            //   189e11327309         | sbb                 byte ptr [esi + 0x9733211], bl
            //   2000                 | and                 byte ptr [eax], al
            //   0aa2112e1828         | or                  ah, byte ptr [edx + 0x28182e11]

        $sequence_9 = { c5740000 1e 007cc902 00c5 }
            // n = 4, score = 100
            //   c5740000             | lds                 esi, ptr [eax + eax]
            //   1e                   | push                ds
            //   007cc902             | add                 byte ptr [ecx + ecx*8 + 2], bh
            //   00c5                 | add                 ch, al

    condition:
        7 of them and filesize < 10454016
}