rule win_teleport_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.teleport."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.teleport"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 894768 893d???????? ff15???????? }
            // n = 4, score = 100
            //   68????????           |                     
            //   894768               | mov                 dword ptr [edi + 0x68], eax
            //   893d????????         |                     
            //   ff15????????         |                     

        $sequence_1 = { 894824 c6401c01 894dfc 8d85d0feffff b912000000 eb50 }
            // n = 6, score = 100
            //   894824               | mov                 dword ptr [eax + 0x24], ecx
            //   c6401c01             | mov                 byte ptr [eax + 0x1c], 1
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   b912000000           | mov                 ecx, 0x12
            //   eb50                 | jmp                 0x52

        $sequence_2 = { 8b04bde83e4300 ff743018 ff15???????? 85c0 0f95c0 5f 5e }
            // n = 7, score = 100
            //   8b04bde83e4300       | mov                 eax, dword ptr [edi*4 + 0x433ee8]
            //   ff743018             | push                dword ptr [eax + esi + 0x18]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f95c0               | setne               al
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { 8b01 6a01 ff10 8b4608 8d7e08 8b08 8900 }
            // n = 7, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   6a01                 | push                1
            //   ff10                 | call                dword ptr [eax]
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8d7e08               | lea                 edi, [esi + 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8900                 | mov                 dword ptr [eax], eax

        $sequence_4 = { 83c404 8b4dc0 0f1003 0f110401 83c010 8945c8 eb06 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   0f1003               | movups              xmm0, xmmword ptr [ebx]
            //   0f110401             | movups              xmmword ptr [ecx + eax], xmm0
            //   83c010               | add                 eax, 0x10
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   eb06                 | jmp                 8

        $sequence_5 = { 8b45ec c1e810 0fb6c0 330c85a0fe4200 0fb6c2 330c85a0f64200 334fe8 }
            // n = 7, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   c1e810               | shr                 eax, 0x10
            //   0fb6c0               | movzx               eax, al
            //   330c85a0fe4200       | xor                 ecx, dword ptr [eax*4 + 0x42fea0]
            //   0fb6c2               | movzx               eax, dl
            //   330c85a0f64200       | xor                 ecx, dword ptr [eax*4 + 0x42f6a0]
            //   334fe8               | xor                 ecx, dword ptr [edi - 0x18]

        $sequence_6 = { 3bf0 745a 0f1f440000 68???????? 8bcf e8???????? 837e1c08 }
            // n = 7, score = 100
            //   3bf0                 | cmp                 esi, eax
            //   745a                 | je                  0x5c
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   68????????           |                     
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   837e1c08             | cmp                 dword ptr [esi + 0x1c], 8

        $sequence_7 = { 8b4104 8987a4000000 8b5108 8945f8 8bc2 8997a8000000 8b590c }
            // n = 7, score = 100
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   8987a4000000         | mov                 dword ptr [edi + 0xa4], eax
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8bc2                 | mov                 eax, edx
            //   8997a8000000         | mov                 dword ptr [edi + 0xa8], edx
            //   8b590c               | mov                 ebx, dword ptr [ecx + 0xc]

        $sequence_8 = { 894820 894824 c6401c01 8d45c0 c745fc08000000 be00100000 }
            // n = 6, score = 100
            //   894820               | mov                 dword ptr [eax + 0x20], ecx
            //   894824               | mov                 dword ptr [eax + 0x24], ecx
            //   c6401c01             | mov                 byte ptr [eax + 0x1c], 1
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   c745fc08000000       | mov                 dword ptr [ebp - 4], 8
            //   be00100000           | mov                 esi, 0x1000

        $sequence_9 = { 0fb6c3 8b5de8 331485a0f64200 3357ac 8bc2 c1e808 0fb6c8 }
            // n = 7, score = 100
            //   0fb6c3               | movzx               eax, bl
            //   8b5de8               | mov                 ebx, dword ptr [ebp - 0x18]
            //   331485a0f64200       | xor                 edx, dword ptr [eax*4 + 0x42f6a0]
            //   3357ac               | xor                 edx, dword ptr [edi - 0x54]
            //   8bc2                 | mov                 eax, edx
            //   c1e808               | shr                 eax, 8
            //   0fb6c8               | movzx               ecx, al

    condition:
        7 of them and filesize < 458752
}