rule win_tempedreve_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tempedreve."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tempedreve"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 663bfb 7407 663b7c2448 7520 0fb77804 }
            // n = 5, score = 300
            //   663bfb               | cmp                 di, bx
            //   7407                 | je                  9
            //   663b7c2448           | cmp                 di, word ptr [esp + 0x48]
            //   7520                 | jne                 0x22
            //   0fb77804             | movzx               edi, word ptr [eax + 4]

        $sequence_1 = { 8d5602 03d1 e9???????? 807dfe80 751e 8a4101 24f8 }
            // n = 7, score = 300
            //   8d5602               | lea                 edx, [esi + 2]
            //   03d1                 | add                 edx, ecx
            //   e9????????           |                     
            //   807dfe80             | cmp                 byte ptr [ebp - 2], 0x80
            //   751e                 | jne                 0x20
            //   8a4101               | mov                 al, byte ptr [ecx + 1]
            //   24f8                 | and                 al, 0xf8

        $sequence_2 = { 83c40c ab 55 8d84247c0e0000 50 }
            // n = 5, score = 300
            //   83c40c               | add                 esp, 0xc
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   55                   | push                ebp
            //   8d84247c0e0000       | lea                 eax, [esp + 0xe7c]
            //   50                   | push                eax

        $sequence_3 = { 0f85c8020000 0fb74314 55 56 0fb77306 }
            // n = 5, score = 300
            //   0f85c8020000         | jne                 0x2ce
            //   0fb74314             | movzx               eax, word ptr [ebx + 0x14]
            //   55                   | push                ebp
            //   56                   | push                esi
            //   0fb77306             | movzx               esi, word ptr [ebx + 6]

        $sequence_4 = { 740e 80fb12 7511 8a4101 24c0 }
            // n = 5, score = 300
            //   740e                 | je                  0x10
            //   80fb12               | cmp                 bl, 0x12
            //   7511                 | jne                 0x13
            //   8a4101               | mov                 al, byte ptr [ecx + 1]
            //   24c0                 | and                 al, 0xc0

        $sequence_5 = { 8a1c1e 8d42d0 46 32c9 3c09 }
            // n = 5, score = 300
            //   8a1c1e               | mov                 bl, byte ptr [esi + ebx]
            //   8d42d0               | lea                 eax, [edx - 0x30]
            //   46                   | inc                 esi
            //   32c9                 | xor                 cl, cl
            //   3c09                 | cmp                 al, 9

        $sequence_6 = { 015308 f7d0 0bc2 33c6 }
            // n = 4, score = 300
            //   015308               | add                 dword ptr [ebx + 8], edx
            //   f7d0                 | not                 eax
            //   0bc2                 | or                  eax, edx
            //   33c6                 | xor                 eax, esi

        $sequence_7 = { ff743bfc 8bcb ff743bf8 e8???????? }
            // n = 4, score = 300
            //   ff743bfc             | push                dword ptr [ebx + edi - 4]
            //   8bcb                 | mov                 ecx, ebx
            //   ff743bf8             | push                dword ptr [ebx + edi - 8]
            //   e8????????           |                     

        $sequence_8 = { 0f85c9000000 8b542430 3bda 7320 8d4d02 }
            // n = 5, score = 200
            //   0f85c9000000         | jne                 0xcf
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   3bda                 | cmp                 ebx, edx
            //   7320                 | jae                 0x22
            //   8d4d02               | lea                 ecx, [ebp + 2]

        $sequence_9 = { c0e801 7434 83d102 89c5 }
            // n = 4, score = 200
            //   c0e801               | shr                 al, 1
            //   7434                 | je                  0x36
            //   83d102               | adc                 ecx, 2
            //   89c5                 | mov                 ebp, eax

        $sequence_10 = { 2bc8 894c2414 3b4c242c 0f8738010000 8b4c2410 }
            // n = 5, score = 200
            //   2bc8                 | sub                 ecx, eax
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   3b4c242c             | cmp                 ecx, dword ptr [esp + 0x2c]
            //   0f8738010000         | ja                  0x13e
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_11 = { c1e903 8d440140 c20400 8b44240c }
            // n = 4, score = 200
            //   c1e903               | shr                 ecx, 3
            //   8d440140             | lea                 eax, [ecx + eax + 0x40]
            //   c20400               | ret                 4
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]

        $sequence_12 = { d1c0 33c7 0fb6b90130cb00 d1c0 }
            // n = 4, score = 200
            //   d1c0                 | rol                 eax, 1
            //   33c7                 | xor                 eax, edi
            //   0fb6b90130cb00       | movzx               edi, byte ptr [ecx + 0xcb3001]
            //   d1c0                 | rol                 eax, 1

        $sequence_13 = { 3a1429 8b4c2414 bb02000000 740c 3b8e24040000 0f85c9000000 }
            // n = 6, score = 200
            //   3a1429               | cmp                 dl, byte ptr [ecx + ebp]
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   bb02000000           | mov                 ebx, 2
            //   740c                 | je                  0xe
            //   3b8e24040000         | cmp                 ecx, dword ptr [esi + 0x424]
            //   0f85c9000000         | jne                 0xcf

        $sequence_14 = { 0f846b010000 83ff01 0f8650010000 8b542454 8bcf 2bcb 8d0411 }
            // n = 7, score = 200
            //   0f846b010000         | je                  0x171
            //   83ff01               | cmp                 edi, 1
            //   0f8650010000         | jbe                 0x156
            //   8b542454             | mov                 edx, dword ptr [esp + 0x54]
            //   8bcf                 | mov                 ecx, edi
            //   2bcb                 | sub                 ecx, ebx
            //   8d0411               | lea                 eax, [ecx + edx]

        $sequence_15 = { f7d0 8944241c 61 c20800 60 8b742424 }
            // n = 6, score = 200
            //   f7d0                 | not                 eax
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   61                   | popal               
            //   c20800               | ret                 8
            //   60                   | pushal              
            //   8b742424             | mov                 esi, dword ptr [esp + 0x24]

    condition:
        7 of them and filesize < 155648
}