rule win_tendyron_dropper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tendyron_dropper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tendyron_dropper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6639430e 750f 6817070000 ff15???????? 33c0 }
            // n = 5, score = 100
            //   6639430e             | cmp                 word ptr [ebx + 0xe], ax
            //   750f                 | jne                 0x11
            //   6817070000           | push                0x717
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 81ec84000000 53 56 57 6a44 8bd8 }
            // n = 6, score = 100
            //   81ec84000000         | sub                 esp, 0x84
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a44                 | push                0x44
            //   8bd8                 | mov                 ebx, eax

        $sequence_2 = { bf00200000 57 8945f0 e8???????? 59 6a00 57 }
            // n = 7, score = 100
            //   bf00200000           | mov                 edi, 0x2000
            //   57                   | push                edi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   6a00                 | push                0
            //   57                   | push                edi

        $sequence_3 = { 85c0 7d0b 3b7d68 7501 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7d0b                 | jge                 0xd
            //   3b7d68               | cmp                 edi, dword ptr [ebp + 0x68]
            //   7501                 | jne                 3

        $sequence_4 = { 56 33db 8d85b0feffff 53 50 e8???????? }
            // n = 6, score = 100
            //   56                   | push                esi
            //   33db                 | xor                 ebx, ebx
            //   8d85b0feffff         | lea                 eax, [ebp - 0x150]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 59 3bf3 0f84f3feffff 8b45fc 53 68d3000000 }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   3bf3                 | cmp                 esi, ebx
            //   0f84f3feffff         | je                  0xfffffef9
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   53                   | push                ebx
            //   68d3000000           | push                0xd3

        $sequence_6 = { 84c9 75f9 2bf2 8bce 8b75fc 33d2 f3a6 }
            // n = 7, score = 100
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bf2                 | sub                 esi, edx
            //   8bce                 | mov                 ecx, esi
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   33d2                 | xor                 edx, edx
            //   f3a6                 | repe cmpsb          byte ptr [esi], byte ptr es:[edi]

        $sequence_7 = { 72ee 83f81e 77e9 833d????????00 }
            // n = 4, score = 100
            //   72ee                 | jb                  0xfffffff0
            //   83f81e               | cmp                 eax, 0x1e
            //   77e9                 | ja                  0xffffffeb
            //   833d????????00       |                     

        $sequence_8 = { 68???????? c70614010000 ff15???????? 50 ff15???????? }
            // n = 5, score = 100
            //   68????????           |                     
            //   c70614010000         | mov                 dword ptr [esi], 0x114
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { 8a01 3429 0429 8801 41 4e }
            // n = 6, score = 100
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   3429                 | xor                 al, 0x29
            //   0429                 | add                 al, 0x29
            //   8801                 | mov                 byte ptr [ecx], al
            //   41                   | inc                 ecx
            //   4e                   | dec                 esi

    condition:
        7 of them and filesize < 58368
}