rule win_termite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.termite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.termite"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7e5e 8b45ec 8b4010 8945f0 c745f400000000 eb41 }
            // n = 6, score = 200
            //   7e5e                 | jle                 0x60
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   eb41                 | jmp                 0x43

        $sequence_1 = { 8b55f4 8b5204 891424 ffd0 8b4508 8b4010 }
            // n = 6, score = 200
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b5204               | mov                 edx, dword ptr [edx + 4]
            //   891424               | mov                 dword ptr [esp], edx
            //   ffd0                 | call                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]

        $sequence_2 = { 8b45f4 89442408 8b450c 89442404 8b45f0 890424 e8???????? }
            // n = 7, score = 200
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_3 = { 83f83f 771c 8b5508 8b45f4 899485f0feffff 8b85ecfeffff }
            // n = 6, score = 200
            //   83f83f               | cmp                 eax, 0x3f
            //   771c                 | ja                  0x1e
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   899485f0feffff       | mov                 dword ptr [ebp + eax*4 - 0x110], edx
            //   8b85ecfeffff         | mov                 eax, dword ptr [ebp - 0x114]

        $sequence_4 = { 8945fc 8b4508 8b4004 3b45f8 7e06 837dfc00 75d7 }
            // n = 7, score = 200
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   3b45f8               | cmp                 eax, dword ptr [ebp - 8]
            //   7e06                 | jle                 8
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   75d7                 | jne                 0xffffffd9

        $sequence_5 = { 8d85e4feffff 89442410 c744240c00000000 c744240800000000 8d85ecfeffff 89442404 891424 }
            // n = 7, score = 200
            //   8d85e4feffff         | lea                 eax, [ebp - 0x11c]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   891424               | mov                 dword ptr [esp], edx

        $sequence_6 = { 890424 e8???????? c745b044000000 c745dc00010000 8b45f4 8945f0 8b45f0 }
            // n = 7, score = 200
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   c745b044000000       | mov                 dword ptr [ebp - 0x50], 0x44
            //   c745dc00010000       | mov                 dword ptr [ebp - 0x24], 0x100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_7 = { c1e002 01d0 c1e002 05???????? c7400c00000000 8b55fc 89d0 }
            // n = 7, score = 200
            //   c1e002               | shl                 eax, 2
            //   01d0                 | add                 eax, edx
            //   c1e002               | shl                 eax, 2
            //   05????????           |                     
            //   c7400c00000000       | mov                 dword ptr [eax + 0xc], 0
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   89d0                 | mov                 eax, edx

        $sequence_8 = { 890424 e8???????? 8b450c 8b400c c744240804000000 8d9568feffff }
            // n = 6, score = 200
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   c744240804000000     | mov                 dword ptr [esp + 8], 4
            //   8d9568feffff         | lea                 edx, [ebp - 0x198]

        $sequence_9 = { c7442404???????? 891c24 8944240c 8d45e1 }
            // n = 4, score = 200
            //   c7442404????????     |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8d45e1               | lea                 eax, [ebp - 0x1f]

    condition:
        7 of them and filesize < 312320
}