rule win_thanatos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.thanatos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thanatos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740a 8b45f8 83e007 3c05 751c 834714fc }
            // n = 6, score = 500
            //   740a                 | je                  0xc
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83e007               | and                 eax, 7
            //   3c05                 | cmp                 al, 5
            //   751c                 | jne                 0x1e
            //   834714fc             | add                 dword ptr [edi + 0x14], -4

        $sequence_1 = { ff15???????? 03c0 50 53 ffb514fdffff 56 ff15???????? }
            // n = 7, score = 500
            //   ff15????????         |                     
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ffb514fdffff         | push                dword ptr [ebp - 0x2ec]
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_2 = { 8b856cffffff 8906 8b8570ffffff 8907 8b4dfc 5f 33cd }
            // n = 7, score = 500
            //   8b856cffffff         | mov                 eax, dword ptr [ebp - 0x94]
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b8570ffffff         | mov                 eax, dword ptr [ebp - 0x90]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   33cd                 | xor                 ecx, ebp

        $sequence_3 = { 56 8d43fe 8bd1 33f6 57 8b7d08 }
            // n = 6, score = 500
            //   56                   | push                esi
            //   8d43fe               | lea                 eax, [ebx - 2]
            //   8bd1                 | mov                 edx, ecx
            //   33f6                 | xor                 esi, esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_4 = { 8d0449 8d0445981c0210 5d c3 8d04cd00000000 2bc1 8d0445c0390210 }
            // n = 7, score = 500
            //   8d0449               | lea                 eax, [ecx + ecx*2]
            //   8d0445981c0210       | lea                 eax, [eax*2 + 0x10021c98]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d04cd00000000       | lea                 eax, [ecx*8]
            //   2bc1                 | sub                 eax, ecx
            //   8d0445c0390210       | lea                 eax, [eax*2 + 0x100239c0]

        $sequence_5 = { 2db8000000 81e6ff1f0000 03f0 0fb7047528f10110 6685c0 74c5 }
            // n = 6, score = 500
            //   2db8000000           | sub                 eax, 0xb8
            //   81e6ff1f0000         | and                 esi, 0x1fff
            //   03f0                 | add                 esi, eax
            //   0fb7047528f10110     | movzx               eax, word ptr [esi*2 + 0x1001f128]
            //   6685c0               | test                ax, ax
            //   74c5                 | je                  0xffffffc7

        $sequence_6 = { 6a00 c705????????00000000 c705????????00000000 ff15???????? 85c0 743e 8d85f0fdffff }
            // n = 7, score = 500
            //   6a00                 | push                0
            //   c705????????00000000     |     
            //   c705????????00000000     |     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   743e                 | je                  0x40
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]

        $sequence_7 = { 66a1???????? 668945f8 a0???????? 83c420 8845fa 8d45f4 50 }
            // n = 7, score = 500
            //   66a1????????         |                     
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   a0????????           |                     
            //   83c420               | add                 esp, 0x20
            //   8845fa               | mov                 byte ptr [ebp - 6], al
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax

        $sequence_8 = { 0f8718010000 8b35???????? 68???????? 53 ffd6 85c0 }
            // n = 6, score = 500
            //   0f8718010000         | ja                  0x11e
            //   8b35????????         |                     
            //   68????????           |                     
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax

        $sequence_9 = { 83e003 c1e004 5f 0fb68028850110 884101 5e }
            // n = 6, score = 500
            //   83e003               | and                 eax, 3
            //   c1e004               | shl                 eax, 4
            //   5f                   | pop                 edi
            //   0fb68028850110       | movzx               eax, byte ptr [eax + 0x10018528]
            //   884101               | mov                 byte ptr [ecx + 1], al
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 1810432
}