rule win_thanatos_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.thanatos_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thanatos_ransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837f1410 7240 8b4714 8b0f 40 3d00100000 722a }
            // n = 7, score = 100
            //   837f1410             | cmp                 dword ptr [edi + 0x14], 0x10
            //   7240                 | jb                  0x42
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   40                   | inc                 eax
            //   3d00100000           | cmp                 eax, 0x1000
            //   722a                 | jb                  0x2c

        $sequence_1 = { 50 e8???????? 83ec18 c645fc13 8bcc c741140f000000 c7411000000000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18
            //   c645fc13             | mov                 byte ptr [ebp - 4], 0x13
            //   8bcc                 | mov                 ecx, esp
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0

        $sequence_2 = { f20f591c8580e94200 f20f592c8580e94200 03c0 660f58348590ed4200 660f5625???????? f20f58f0 }
            // n = 6, score = 100
            //   f20f591c8580e94200     | mulsd    xmm3, qword ptr [eax*4 + 0x42e980]
            //   f20f592c8580e94200     | mulsd    xmm5, qword ptr [eax*4 + 0x42e980]
            //   03c0                 | add                 eax, eax
            //   660f58348590ed4200     | addpd    xmm6, xmmword ptr [eax*4 + 0x42ed90]
            //   660f5625????????     |                     
            //   f20f58f0             | addsd               xmm6, xmm0

        $sequence_3 = { 6bc930 f6451402 8b0485e0774300 c644082900 }
            // n = 4, score = 100
            //   6bc930               | imul                ecx, ecx, 0x30
            //   f6451402             | test                byte ptr [ebp + 0x14], 2
            //   8b0485e0774300       | mov                 eax, dword ptr [eax*4 + 0x4377e0]
            //   c644082900           | mov                 byte ptr [eax + ecx + 0x29], 0

        $sequence_4 = { c64405e800 40 83f804 7cef 33f6 0f1f440000 8a4435e8 }
            // n = 7, score = 100
            //   c64405e800           | mov                 byte ptr [ebp + eax - 0x18], 0
            //   40                   | inc                 eax
            //   83f804               | cmp                 eax, 4
            //   7cef                 | jl                  0xfffffff1
            //   33f6                 | xor                 esi, esi
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8a4435e8             | mov                 al, byte ptr [ebp + esi - 0x18]

        $sequence_5 = { c645fc14 8d4dd8 e8???????? 83c404 68???????? 8bd0 }
            // n = 6, score = 100
            //   c645fc14             | mov                 byte ptr [ebp - 4], 0x14
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   68????????           |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_6 = { 8b7508 8bce 68b8020000 68???????? c745fc00000000 }
            // n = 5, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8bce                 | mov                 ecx, esi
            //   68b8020000           | push                0x2b8
            //   68????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_7 = { e8???????? 83c404 c645fc12 8b45ec c745d40f000000 c745d000000000 c645c000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c645fc12             | mov                 byte ptr [ebp - 4], 0x12
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   c745d40f000000       | mov                 dword ptr [ebp - 0x2c], 0xf
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   c645c000             | mov                 byte ptr [ebp - 0x40], 0

        $sequence_8 = { 43 837e1410 7204 8b06 eb02 }
            // n = 5, score = 100
            //   43                   | inc                 ebx
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10
            //   7204                 | jb                  6
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   eb02                 | jmp                 4

        $sequence_9 = { 83f81d 7cf1 eb07 8b0cc544be4200 894de4 }
            // n = 5, score = 100
            //   83f81d               | cmp                 eax, 0x1d
            //   7cf1                 | jl                  0xfffffff3
            //   eb07                 | jmp                 9
            //   8b0cc544be4200       | mov                 ecx, dword ptr [eax*8 + 0x42be44]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx

    condition:
        7 of them and filesize < 516096
}