rule win_threebyte_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.threebyte."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.threebyte"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b9598fbffff 52 8d859cfbffff 50 8d8d4cf7ffff 51 8d956cf7ffff }
            // n = 7, score = 200
            //   8b9598fbffff         | mov                 edx, dword ptr [ebp - 0x468]
            //   52                   | push                edx
            //   8d859cfbffff         | lea                 eax, [ebp - 0x464]
            //   50                   | push                eax
            //   8d8d4cf7ffff         | lea                 ecx, [ebp - 0x8b4]
            //   51                   | push                ecx
            //   8d956cf7ffff         | lea                 edx, [ebp - 0x894]

        $sequence_1 = { 6a20 68cc000000 8d8de0fdffff 51 e8???????? 83c40c }
            // n = 6, score = 200
            //   6a20                 | push                0x20
            //   68cc000000           | push                0xcc
            //   8d8de0fdffff         | lea                 ecx, [ebp - 0x220]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_2 = { c68531faffff6d c68532faffff65 c68533faffff00 8d8d28faffff 51 8b95a8faffff 52 }
            // n = 7, score = 200
            //   c68531faffff6d       | mov                 byte ptr [ebp - 0x5cf], 0x6d
            //   c68532faffff65       | mov                 byte ptr [ebp - 0x5ce], 0x65
            //   c68533faffff00       | mov                 byte ptr [ebp - 0x5cd], 0
            //   8d8d28faffff         | lea                 ecx, [ebp - 0x5d8]
            //   51                   | push                ecx
            //   8b95a8faffff         | mov                 edx, dword ptr [ebp - 0x558]
            //   52                   | push                edx

        $sequence_3 = { 52 8d8544feffff 50 8d8dccfeffff 51 e8???????? }
            // n = 6, score = 200
            //   52                   | push                edx
            //   8d8544feffff         | lea                 eax, [ebp - 0x1bc]
            //   50                   | push                eax
            //   8d8dccfeffff         | lea                 ecx, [ebp - 0x134]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_4 = { ff15???????? 8d95ccfcffff 52 8d8510f8ffff 50 8d8dd0fdffff 51 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8d95ccfcffff         | lea                 edx, [ebp - 0x334]
            //   52                   | push                edx
            //   8d8510f8ffff         | lea                 eax, [ebp - 0x7f0]
            //   50                   | push                eax
            //   8d8dd0fdffff         | lea                 ecx, [ebp - 0x230]
            //   51                   | push                ecx

        $sequence_5 = { c685b1fdffff00 ff15???????? 50 8d8d94fdffff 51 }
            // n = 5, score = 200
            //   c685b1fdffff00       | mov                 byte ptr [ebp - 0x24f], 0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d8d94fdffff         | lea                 ecx, [ebp - 0x26c]
            //   51                   | push                ecx

        $sequence_6 = { 81bda4f7fffff6010000 7507 b8faffffff eb05 b8f9ffffff 5f 8be5 }
            // n = 7, score = 200
            //   81bda4f7fffff6010000     | cmp    dword ptr [ebp - 0x85c], 0x1f6
            //   7507                 | jne                 9
            //   b8faffffff           | mov                 eax, 0xfffffffa
            //   eb05                 | jmp                 7
            //   b8f9ffffff           | mov                 eax, 0xfffffff9
            //   5f                   | pop                 edi
            //   8be5                 | mov                 esp, ebp

        $sequence_7 = { e8???????? 83c404 e9???????? 6a02 6a00 6a00 8b95d0fdffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e9????????           |                     
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8b95d0fdffff         | mov                 edx, dword ptr [ebp - 0x230]

        $sequence_8 = { 50 e8???????? 83c408 89853cffffff 83bd3cffffff00 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   89853cffffff         | mov                 dword ptr [ebp - 0xc4], eax
            //   83bd3cffffff00       | cmp                 dword ptr [ebp - 0xc4], 0

        $sequence_9 = { 3b4d0c 7d15 8b5508 33c0 8a02 8945e0 8b4d08 }
            // n = 7, score = 200
            //   3b4d0c               | cmp                 ecx, dword ptr [ebp + 0xc]
            //   7d15                 | jge                 0x17
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   8a02                 | mov                 al, byte ptr [edx]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 180224
}