rule win_thumbthief_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.thumbthief."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thumbthief"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7604 e8???????? 83c410 895e04 5f 8bc6 5e }
            // n = 7, score = 100
            //   ff7604               | push                dword ptr [esi + 4]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   895e04               | mov                 dword ptr [esi + 4], ebx
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_1 = { ff7010 e8???????? 0fb74612 8d4dc8 50 68???????? e8???????? }
            // n = 7, score = 100
            //   ff7010               | push                dword ptr [eax + 0x10]
            //   e8????????           |                     
            //   0fb74612             | movzx               eax, word ptr [esi + 0x12]
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_2 = { e8???????? c645fc03 85f6 7526 68???????? 68???????? 8d8d2cffffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   85f6                 | test                esi, esi
            //   7526                 | jne                 0x28
            //   68????????           |                     
            //   68????????           |                     
            //   8d8d2cffffff         | lea                 ecx, [ebp - 0xd4]

        $sequence_3 = { e8???????? 8d742440 8d7c2414 a5 8d442414 6a01 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d742440             | lea                 esi, [esp + 0x40]
            //   8d7c2414             | lea                 edi, [esp + 0x14]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   6a01                 | push                1
            //   50                   | push                eax

        $sequence_4 = { e9???????? 8b542434 395608 8b542428 0f85b1000000 8b4c2430 898c24c0000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b542434             | mov                 edx, dword ptr [esp + 0x34]
            //   395608               | cmp                 dword ptr [esi + 8], edx
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   0f85b1000000         | jne                 0xb7
            //   8b4c2430             | mov                 ecx, dword ptr [esp + 0x30]
            //   898c24c0000000       | mov                 dword ptr [esp + 0xc0], ecx

        $sequence_5 = { e8???????? 8d8c24bc010000 e8???????? 8d4314 50 68a0000000 53 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8c24bc010000       | lea                 ecx, [esp + 0x1bc]
            //   e8????????           |                     
            //   8d4314               | lea                 eax, [ebx + 0x14]
            //   50                   | push                eax
            //   68a0000000           | push                0xa0
            //   53                   | push                ebx

        $sequence_6 = { ff15???????? 68???????? ff75dc ffd7 50 8d8dd8feffff e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   8d8dd8feffff         | lea                 ecx, [ebp - 0x128]
            //   e8????????           |                     

        $sequence_7 = { ff248580c94200 8b4508 b901000000 6689481c 33c0 5f 5e }
            // n = 7, score = 100
            //   ff248580c94200       | jmp                 dword ptr [eax*4 + 0x42c980]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   b901000000           | mov                 ecx, 1
            //   6689481c             | mov                 word ptr [eax + 0x1c], cx
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { f20f1045c4 83c408 f20f1187b8010000 8bc6 5f 5e 5b }
            // n = 7, score = 100
            //   f20f1045c4           | movsd               xmm0, qword ptr [ebp - 0x3c]
            //   83c408               | add                 esp, 8
            //   f20f1187b8010000     | movsd               qword ptr [edi + 0x1b8], xmm0
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_9 = { ff75f4 e8???????? 83c414 8bd6 8bcb e8???????? 837d1000 }
            // n = 7, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8bd6                 | mov                 edx, esi
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0

    condition:
        7 of them and filesize < 4235264
}