rule win_thunderx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.thunderx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thunderx"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 e8???????? 59 8d45b0 8bcf 50 e8???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   8bcf                 | mov                 ecx, edi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 75f2 85c9 7509 3bc6 740b 83e802 ebd7 }
            // n = 7, score = 200
            //   75f2                 | jne                 0xfffffff4
            //   85c9                 | test                ecx, ecx
            //   7509                 | jne                 0xb
            //   3bc6                 | cmp                 eax, esi
            //   740b                 | je                  0xd
            //   83e802               | sub                 eax, 2
            //   ebd7                 | jmp                 0xffffffd9

        $sequence_2 = { 8bcb e8???????? 83c318 83c618 895de0 3bf7 75eb }
            // n = 7, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   83c318               | add                 ebx, 0x18
            //   83c618               | add                 esi, 0x18
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   3bf7                 | cmp                 esi, edi
            //   75eb                 | jne                 0xffffffed

        $sequence_3 = { 8b35???????? ffd6 ff75ec ffd6 b001 eb02 32c0 }
            // n = 7, score = 200
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ffd6                 | call                esi
            //   b001                 | mov                 al, 1
            //   eb02                 | jmp                 4
            //   32c0                 | xor                 al, al

        $sequence_4 = { 7462 8b44240c 3b05???????? 7556 8b442410 89442438 8b442414 }
            // n = 7, score = 200
            //   7462                 | je                  0x64
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   3b05????????         |                     
            //   7556                 | jne                 0x58
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   89442438             | mov                 dword ptr [esp + 0x38], eax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]

        $sequence_5 = { c3 6a54 b8???????? e8???????? 8bf9 897dac }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   6a54                 | push                0x54
            //   b8????????           |                     
            //   e8????????           |                     
            //   8bf9                 | mov                 edi, ecx
            //   897dac               | mov                 dword ptr [ebp - 0x54], edi

        $sequence_6 = { 7415 ff15???????? 85c0 750b e8???????? 84c0 }
            // n = 6, score = 200
            //   7415                 | je                  0x17
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750b                 | jne                 0xd
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_7 = { 59 56 8bd0 885dfc 8d8d40feffff e8???????? 59 }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   56                   | push                esi
            //   8bd0                 | mov                 edx, eax
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   8d8d40feffff         | lea                 ecx, [ebp - 0x1c0]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_8 = { e8???????? 8d8dc8fdffff e8???????? 8d8db0fdffff c645fc05 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8d8dc8fdffff         | lea                 ecx, [ebp - 0x238]
            //   e8????????           |                     
            //   8d8db0fdffff         | lea                 ecx, [ebp - 0x250]
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   e8????????           |                     

        $sequence_9 = { 8bfa 2b7d0c eb02 8bfe }
            // n = 4, score = 200
            //   8bfa                 | mov                 edi, edx
            //   2b7d0c               | sub                 edi, dword ptr [ebp + 0xc]
            //   eb02                 | jmp                 4
            //   8bfe                 | mov                 edi, esi

    condition:
        7 of them and filesize < 319488
}