rule win_tidepool_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tidepool."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tidepool"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5f 5e 5b 8b8d00030000 }
            // n = 4, score = 1000
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8b8d00030000         | mov                 ecx, dword ptr [ebp + 0x300]

        $sequence_1 = { 8b8d00030000 33cd e8???????? 81c504030000 }
            // n = 4, score = 1000
            //   8b8d00030000         | mov                 ecx, dword ptr [ebp + 0x300]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   81c504030000         | add                 ebp, 0x304

        $sequence_2 = { 6a00 50 8b08 ff91a4000000 }
            // n = 4, score = 1000
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff91a4000000         | call                dword ptr [ecx + 0xa4]

        $sequence_3 = { 8bc6 5e c20400 80790800 c701???????? 740e 8b4904 }
            // n = 7, score = 1000
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   80790800             | cmp                 byte ptr [ecx + 8], 0
            //   c701????????         |                     
            //   740e                 | je                  0x10
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]

        $sequence_4 = { 53 6a02 8bf1 e8???????? }
            // n = 4, score = 900
            //   53                   | push                ebx
            //   6a02                 | push                2
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     

        $sequence_5 = { 83c40c 803d????????37 7518 68???????? }
            // n = 4, score = 900
            //   83c40c               | add                 esp, 0xc
            //   803d????????37       |                     
            //   7518                 | jne                 0x1a
            //   68????????           |                     

        $sequence_6 = { 6800000040 8d4500 50 ff15???????? }
            // n = 4, score = 900
            //   6800000040           | push                0x40000000
            //   8d4500               | lea                 eax, [ebp]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { 83e906 51 83c006 50 6a02 }
            // n = 5, score = 900
            //   83e906               | sub                 ecx, 6
            //   51                   | push                ecx
            //   83c006               | add                 eax, 6
            //   50                   | push                eax
            //   6a02                 | push                2

        $sequence_8 = { 681f000200 56 68???????? 6801000080 }
            // n = 4, score = 800
            //   681f000200           | push                0x2001f
            //   56                   | push                esi
            //   68????????           |                     
            //   6801000080           | push                0x80000001

        $sequence_9 = { 5e 5f 5b c9 c3 ff25???????? 51 }
            // n = 7, score = 800
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 
            //   ff25????????         |                     
            //   51                   | push                ecx

        $sequence_10 = { e8???????? 68???????? 68???????? 68???????? 8d4500 }
            // n = 5, score = 800
            //   e8????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   8d4500               | lea                 eax, [ebp]

        $sequence_11 = { 75f9 b8???????? b900000400 c60000 40 49 }
            // n = 6, score = 800
            //   75f9                 | jne                 0xfffffffb
            //   b8????????           |                     
            //   b900000400           | mov                 ecx, 0x40000
            //   c60000               | mov                 byte ptr [eax], 0
            //   40                   | inc                 eax
            //   49                   | dec                 ecx

        $sequence_12 = { 8b08 ff91a4000000 8b4654 6a01 }
            // n = 4, score = 800
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff91a4000000         | call                dword ptr [ecx + 0xa4]
            //   8b4654               | mov                 eax, dword ptr [esi + 0x54]
            //   6a01                 | push                1

        $sequence_13 = { 8d5658 52 50 ff91d0000000 }
            // n = 4, score = 800
            //   8d5658               | lea                 edx, [esi + 0x58]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff91d0000000         | call                dword ptr [ecx + 0xd0]

        $sequence_14 = { 6810270000 ff15???????? 8b45ec 8b08 }
            // n = 4, score = 800
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_15 = { 7509 8b4654 50 8b08 ff5138 47 }
            // n = 6, score = 800
            //   7509                 | jne                 0xb
            //   8b4654               | mov                 eax, dword ptr [esi + 0x54]
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5138               | call                dword ptr [ecx + 0x38]
            //   47                   | inc                 edi

        $sequence_16 = { 40 49 75f9 b8???????? b900000400 }
            // n = 5, score = 800
            //   40                   | inc                 eax
            //   49                   | dec                 ecx
            //   75f9                 | jne                 0xfffffffb
            //   b8????????           |                     
            //   b900000400           | mov                 ecx, 0x40000

        $sequence_17 = { 8d45ec 50 681f000200 53 68???????? }
            // n = 5, score = 800
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   681f000200           | push                0x2001f
            //   53                   | push                ebx
            //   68????????           |                     

        $sequence_18 = { 56 8bf1 e8???????? 8b4654 6a00 }
            // n = 5, score = 800
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   8b4654               | mov                 eax, dword ptr [esi + 0x54]
            //   6a00                 | push                0

        $sequence_19 = { 6802020000 ff15???????? 68???????? ff15???????? 8bf8 }
            // n = 5, score = 800
            //   6802020000           | push                0x202
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_20 = { 2bca 33d2 85c9 894c2410 89542414 }
            // n = 5, score = 600
            //   2bca                 | sub                 ecx, edx
            //   33d2                 | xor                 edx, edx
            //   85c9                 | test                ecx, ecx
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   89542414             | mov                 dword ptr [esp + 0x14], edx

        $sequence_21 = { 89442424 7e13 51 8d542428 }
            // n = 4, score = 600
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   7e13                 | jle                 0x15
            //   51                   | push                ecx
            //   8d542428             | lea                 edx, [esp + 0x28]

        $sequence_22 = { ff75ec ff15???????? 8b35???????? 6a04 }
            // n = 4, score = 400
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   6a04                 | push                4

        $sequence_23 = { 53 50 ff75f8 ff75e4 ff75fc ff15???????? }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     

        $sequence_24 = { 7504 802000 4b 57 }
            // n = 4, score = 200
            //   7504                 | jne                 6
            //   802000               | and                 byte ptr [eax], 0
            //   4b                   | dec                 ebx
            //   57                   | push                edi

        $sequence_25 = { 59 ff15???????? 8b4df8 8945d8 8b45fc 8d840832010000 }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8d840832010000       | lea                 eax, [eax + ecx + 0x132]

        $sequence_26 = { 56 e8???????? 8b7d08 57 e8???????? d1e0 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   e8????????           |                     
            //   d1e0                 | shl                 eax, 1

        $sequence_27 = { 895dd4 895dac 895de0 885def 895de8 66ab }
            // n = 6, score = 200
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx
            //   895dac               | mov                 dword ptr [ebp - 0x54], ebx
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   885def               | mov                 byte ptr [ebp - 0x11], bl
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_28 = { 3bf3 7e16 e8???????? 6a1a }
            // n = 4, score = 200
            //   3bf3                 | cmp                 esi, ebx
            //   7e16                 | jle                 0x18
            //   e8????????           |                     
            //   6a1a                 | push                0x1a

    condition:
        7 of them and filesize < 1998848
}