rule win_tiny_turla_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tiny_turla."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tiny_turla"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c705????????04000000 488bc8 ff15???????? 85c0 742c 488bcb }
            // n = 6, score = 300
            //   c705????????04000000     |     
            //   488bc8               | mov                 eax, edx
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   742c                 | cmp                 eax, 0x20
            //   488bcb               | dec                 esp

        $sequence_1 = { 85c0 742c 488bcb e8???????? 488b0d???????? }
            // n = 5, score = 300
            //   85c0                 | mov                 edx, ecx
            //   742c                 | dec                 eax
            //   488bcb               | mov                 dword ptr [esp + 0x20], eax
            //   e8????????           |                     
            //   488b0d????????       |                     

        $sequence_2 = { 4883ec20 488b1a 488d15e0ffffff 488bcb }
            // n = 4, score = 300
            //   4883ec20             | inc                 edx
            //   488b1a               | inc                 esp
            //   488d15e0ffffff       | mov                 byte ptr [ebp + 0x6f], ch
            //   488bcb               | inc                 esp

        $sequence_3 = { c705????????01000000 4883c420 5b 48ff25???????? }
            // n = 4, score = 300
            //   c705????????01000000     |     
            //   4883c420             | dec                 esp
            //   5b                   | sub                 ecx, edi
            //   48ff25????????       |                     

        $sequence_4 = { 4883ec20 488b1a 488d15e0ffffff 488bcb ff15???????? 488905???????? 4885c0 }
            // n = 7, score = 300
            //   4883ec20             | test                eax, eax
            //   488b1a               | je                  0x871
            //   488d15e0ffffff       | dec                 eax
            //   488bcb               | mov                 ecx, dword ptr [esp + 0x58]
            //   ff15????????         |                     
            //   488905????????       |                     
            //   4885c0               | dec                 eax

        $sequence_5 = { 488bcb ff15???????? 488905???????? 4885c0 744a }
            // n = 5, score = 300
            //   488bcb               | xor                 ecx, ecx
            //   ff15????????         |                     
            //   488905????????       |                     
            //   4885c0               | mov                 al, 5
            //   744a                 | mov                 ecx, dword ptr [edi]

        $sequence_6 = { c705????????01000000 4883c420 5b 48ff25???????? 4883c420 }
            // n = 5, score = 300
            //   c705????????01000000     |     
            //   4883c420             | dec                 eax
            //   5b                   | mov                 dword ptr [esp + 0x40], eax
            //   48ff25????????       |                     
            //   4883c420             | dec                 esp

        $sequence_7 = { 488d15e0ffffff 488bcb ff15???????? 488905???????? 4885c0 }
            // n = 5, score = 300
            //   488d15e0ffffff       | movzx               eax, dx
            //   488bcb               | lea                 edi, [edi - 0x18]
            //   ff15????????         |                     
            //   488905????????       |                     
            //   4885c0               | lea                 edi, [eax + edi*2]

        $sequence_8 = { ff15???????? 85c0 742c 488bcb e8???????? 488b0d???????? }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [ebp], eax
            //   742c                 | dec                 eax
            //   488bcb               | lea                 eax, [esp + 0x68]
            //   e8????????           |                     
            //   488b0d????????       |                     

        $sequence_9 = { ff15???????? 85c0 742c 488bcb e8???????? }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   85c0                 | dec                 esp
            //   742c                 | lea                 eax, [0xbed0]
            //   488bcb               | and                 edx, 0x3f
            //   e8????????           |                     

    condition:
        7 of them and filesize < 217088
}