rule win_tinymet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tinymet."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinymet"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8b400c ff750c 8b00 8b00 a3???????? }
            // n = 6, score = 100
            //   e9????????           |                     
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   a3????????           |                     

        $sequence_1 = { 7419 a1???????? 6a00 83c005 56 }
            // n = 5, score = 100
            //   7419                 | je                  0x1b
            //   a1????????           |                     
            //   6a00                 | push                0
            //   83c005               | add                 eax, 5
            //   56                   | push                esi

        $sequence_2 = { 5e 5d c3 a1???????? 56 57 6a5c }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   a1????????           |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a5c                 | push                0x5c

        $sequence_3 = { 85c0 0f8545010000 ff7508 ff15???????? 85c0 750a 68???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f8545010000         | jne                 0x14b
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   68????????           |                     

        $sequence_4 = { 385d10 7416 6a04 8d45fc }
            // n = 4, score = 100
            //   385d10               | cmp                 byte ptr [ebp + 0x10], bl
            //   7416                 | je                  0x18
            //   6a04                 | push                4
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_5 = { 8d45f0 50 8d45e8 50 e8???????? 83c410 b80033a084 }
            // n = 7, score = 100
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   b80033a084           | mov                 eax, 0x84a03300

        $sequence_6 = { a1???????? 59 50 ff35???????? }
            // n = 4, score = 100
            //   a1????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   ff35????????         |                     

        $sequence_7 = { 33c0 57 668906 e8???????? a3???????? 8d4602 50 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   57                   | push                edi
            //   668906               | mov                 word ptr [esi], ax
            //   e8????????           |                     
            //   a3????????           |                     
            //   8d4602               | lea                 eax, [esi + 2]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 57344
}