rule win_tinynuke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tinynuke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinynuke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 55 8bec 817d0c00040000 }
            // n = 4, score = 1600
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   817d0c00040000       | cmp                 dword ptr [ebp + 0xc], 0x400

        $sequence_1 = { ff15???????? ff35???????? 8b7dfc 57 a3???????? ff15???????? ff35???????? }
            // n = 7, score = 1400
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   57                   | push                edi
            //   a3????????           |                     
            //   ff15????????         |                     
            //   ff35????????         |                     

        $sequence_2 = { 5e 85c0 753c 56 8d45f8 }
            // n = 5, score = 1400
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax
            //   753c                 | jne                 0x3e
            //   56                   | push                esi
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_3 = { 8945f4 8d85d4feffff 50 ff15???????? }
            // n = 4, score = 1400
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8d85d4feffff         | lea                 eax, [ebp - 0x12c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { 83c418 a3???????? 5f 5e 5b c9 c3 }
            // n = 7, score = 1400
            //   83c418               | add                 esp, 0x18
            //   a3????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_5 = { 8d8530f6ffff 50 6802020000 ff15???????? }
            // n = 4, score = 1400
            //   8d8530f6ffff         | lea                 eax, [ebp - 0x9d0]
            //   50                   | push                eax
            //   6802020000           | push                0x202
            //   ff15????????         |                     

        $sequence_6 = { 53 56 57 33c0 33db 6a07 }
            // n = 6, score = 1400
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   33db                 | xor                 ebx, ebx
            //   6a07                 | push                7

        $sequence_7 = { 6a03 53 53 6800000080 50 ff15???????? a3???????? }
            // n = 7, score = 1400
            //   6a03                 | push                3
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6800000080           | push                0x80000000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_8 = { ff75ec ff75fc e8???????? 83c40c 5f }
            // n = 5, score = 1300
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   5f                   | pop                 edi

        $sequence_9 = { 50 ff15???????? ff35???????? 8d85a4feffff 50 ff15???????? }
            // n = 6, score = 1300
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   8d85a4feffff         | lea                 eax, [ebp - 0x15c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_10 = { a3???????? 68e2010000 68???????? 68???????? e8???????? }
            // n = 5, score = 800
            //   a3????????           |                     
            //   68e2010000           | push                0x1e2
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_11 = { 8b02 8a00 3c0a 7409 3c0d }
            // n = 5, score = 800
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8a00                 | mov                 al, byte ptr [eax]
            //   3c0a                 | cmp                 al, 0xa
            //   7409                 | je                  0xb
            //   3c0d                 | cmp                 al, 0xd

        $sequence_12 = { 6a2a 50 8945fc ff15???????? }
            // n = 4, score = 800
            //   6a2a                 | push                0x2a
            //   50                   | push                eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff15????????         |                     

        $sequence_13 = { ff15???????? a3???????? ff35???????? ff75ec ff15???????? }
            // n = 5, score = 800
            //   ff15????????         |                     
            //   a3????????           |                     
            //   ff35????????         |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff15????????         |                     

        $sequence_14 = { a3???????? ff35???????? ff75f8 ff15???????? }
            // n = 4, score = 800
            //   a3????????           |                     
            //   ff35????????         |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     

        $sequence_15 = { c70604000000 e8???????? eb18 83f803 7519 }
            // n = 5, score = 800
            //   c70604000000         | mov                 dword ptr [esi], 4
            //   e8????????           |                     
            //   eb18                 | jmp                 0x1a
            //   83f803               | cmp                 eax, 3
            //   7519                 | jne                 0x1b

        $sequence_16 = { 59 8d85d0fcffff 50 8d85d8feffff 50 ff15???????? ff35???????? }
            // n = 7, score = 700
            //   59                   | pop                 ecx
            //   8d85d0fcffff         | lea                 eax, [ebp - 0x330]
            //   50                   | push                eax
            //   8d85d8feffff         | lea                 eax, [ebp - 0x128]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff35????????         |                     

        $sequence_17 = { 8d45dc 50 ff15???????? 8d85d0fcffff 50 e8???????? }
            // n = 6, score = 700
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d85d0fcffff         | lea                 eax, [ebp - 0x330]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_18 = { 8d85d4fdffff 50 ff15???????? ff35???????? 8d85d4fdffff 50 ff15???????? }
            // n = 7, score = 700
            //   8d85d4fdffff         | lea                 eax, [ebp - 0x22c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   8d85d4fdffff         | lea                 eax, [ebp - 0x22c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_19 = { ff15???????? 8b35???????? 8d430c 50 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   8d430c               | lea                 eax, [ebx + 0xc]
            //   50                   | push                eax

        $sequence_20 = { e8???????? 8945fc 8b0f 83ec08 85c9 75d6 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   83ec08               | sub                 esp, 8
            //   85c9                 | test                ecx, ecx
            //   75d6                 | jne                 0xffffffd8

        $sequence_21 = { c70424???????? e8???????? 83ec08 85c0 75d6 }
            // n = 5, score = 100
            //   c70424????????       |                     
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   85c0                 | test                eax, eax
            //   75d6                 | jne                 0xffffffd8

        $sequence_22 = { 85c0 7422 8b0cb2 83ec08 03cf ba???????? }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7422                 | je                  0x24
            //   8b0cb2               | mov                 ecx, dword ptr [edx + esi*4]
            //   83ec08               | sub                 esp, 8
            //   03cf                 | add                 ecx, edi
            //   ba????????           |                     

        $sequence_23 = { 891c24 89442408 e8???????? 0fb76f06 }
            // n = 4, score = 100
            //   891c24               | mov                 dword ptr [esp], ebx
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   e8????????           |                     
            //   0fb76f06             | movzx               ebp, word ptr [edi + 6]

        $sequence_24 = { c785e4fdffff00000000 c785e0fdffff01000000 f3ab ff15???????? 8d85e8fdffff 6804010000 }
            // n = 6, score = 100
            //   c785e4fdffff00000000     | mov    dword ptr [ebp - 0x21c], 0
            //   c785e0fdffff01000000     | mov    dword ptr [ebp - 0x220], 1
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   ff15????????         |                     
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]
            //   6804010000           | push                0x104

        $sequence_25 = { e8???????? 83ec08 89c3 c7042400000000 e8???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   89c3                 | mov                 ebx, eax
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   e8????????           |                     

        $sequence_26 = { 5b c20800 891c24 e8???????? 83ec04 }
            // n = 5, score = 100
            //   5b                   | pop                 ebx
            //   c20800               | ret                 8
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4

        $sequence_27 = { 89bdb8fdffff ff15???????? 83bdbcfdffff01 7477 8b85c4fdffff }
            // n = 5, score = 100
            //   89bdb8fdffff         | mov                 dword ptr [ebp - 0x248], edi
            //   ff15????????         |                     
            //   83bdbcfdffff01       | cmp                 dword ptr [ebp - 0x244], 1
            //   7477                 | je                  0x79
            //   8b85c4fdffff         | mov                 eax, dword ptr [ebp - 0x23c]

        $sequence_28 = { 83ec0c 31c0 83c43c 5b 5e }
            // n = 5, score = 100
            //   83ec0c               | sub                 esp, 0xc
            //   31c0                 | xor                 eax, eax
            //   83c43c               | add                 esp, 0x3c
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_29 = { 837c243401 7537 c744241400000000 c744241000000000 c744240c00000000 c7442408???????? c744240400000000 }
            // n = 7, score = 100
            //   837c243401           | cmp                 dword ptr [esp + 0x34], 1
            //   7537                 | jne                 0x39
            //   c744241400000000     | mov                 dword ptr [esp + 0x14], 0
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   c7442408????????     |                     
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0

        $sequence_30 = { 85c0 75d6 31db 8d742600 c70424???????? }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   75d6                 | jne                 0xffffffd8
            //   31db                 | xor                 ebx, ebx
            //   8d742600             | lea                 esi, [esi]
            //   c70424????????       |                     

    condition:
        7 of them and filesize < 1196032
}