rule win_tinytyphon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tinytyphon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinytyphon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 ff15???????? 8d55ec 52 ff15???????? 8d45ec }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d45ec               | lea                 eax, [ebp - 0x14]

        $sequence_1 = { 7412 68???????? 8d85e8feffff 50 ff15???????? 8d8dccfdffff 51 }
            // n = 7, score = 200
            //   7412                 | je                  0x14
            //   68????????           |                     
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d8dccfdffff         | lea                 ecx, [ebp - 0x234]
            //   51                   | push                ecx

        $sequence_2 = { 0bc2 8b4df4 0fb6512b c1e218 0bc2 8b4d08 }
            // n = 6, score = 200
            //   0bc2                 | or                  eax, edx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   0fb6512b             | movzx               edx, byte ptr [ecx + 0x2b]
            //   c1e218               | shl                 edx, 0x18
            //   0bc2                 | or                  eax, edx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_3 = { 8b55c8 0355c0 8b45d4 0345c0 8a08 880a }
            // n = 6, score = 200
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   0355c0               | add                 edx, dword ptr [ebp - 0x40]
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   0345c0               | add                 eax, dword ptr [ebp - 0x40]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   880a                 | mov                 byte ptr [edx], cl

        $sequence_4 = { 8b550c 8b4208 50 68???????? 8b4d08 51 ff15???????? }
            // n = 7, score = 200
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   50                   | push                eax
            //   68????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_5 = { 83bd54ffffff00 7517 8b9558ffffff 52 ff15???????? b801000000 e9???????? }
            // n = 7, score = 200
            //   83bd54ffffff00       | cmp                 dword ptr [ebp - 0xac], 0
            //   7517                 | jne                 0x19
            //   8b9558ffffff         | mov                 edx, dword ptr [ebp - 0xa8]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   b801000000           | mov                 eax, 1
            //   e9????????           |                     

        $sequence_6 = { c1e918 8b550c 884a53 8b450c }
            // n = 4, score = 200
            //   c1e918               | shr                 ecx, 0x18
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   884a53               | mov                 byte ptr [edx + 0x53], cl
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_7 = { 85c0 744b 8b5508 0fb602 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   744b                 | je                  0x4d
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0fb602               | movzx               eax, byte ptr [edx]

        $sequence_8 = { 8945f0 837df000 0f8485000000 8b4df0 0fbe5108 83fa02 7410 }
            // n = 7, score = 200
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   0f8485000000         | je                  0x8b
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   0fbe5108             | movsx               edx, byte ptr [ecx + 8]
            //   83fa02               | cmp                 edx, 2
            //   7410                 | je                  0x12

        $sequence_9 = { 8945f8 8b4ddc f7d1 0b4df8 334de4 8b5508 038a94000000 }
            // n = 7, score = 200
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   f7d1                 | not                 ecx
            //   0b4df8               | or                  ecx, dword ptr [ebp - 8]
            //   334de4               | xor                 ecx, dword ptr [ebp - 0x1c]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   038a94000000         | add                 ecx, dword ptr [edx + 0x94]

    condition:
        7 of them and filesize < 90112
}