rule win_tiop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tiop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tiop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd7 8d4c241c a3???????? e8???????? 8b10 53 8bc8 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   a3????????           |                     
            //   e8????????           |                     
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   53                   | push                ebx
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { 57 8965e8 8b4508 8d7004 8975e4 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d7004               | lea                 esi, [eax + 4]
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi

        $sequence_2 = { 51 50 ffd7 83c408 85c0 7555 8b4604 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7555                 | jne                 0x57
            //   8b4604               | mov                 eax, dword ptr [esi + 4]

        $sequence_3 = { 64a100000000 50 64892500000000 83ec08 b8fc120000 e8???????? }
            // n = 6, score = 100
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   83ec08               | sub                 esp, 8
            //   b8fc120000           | mov                 eax, 0x12fc
            //   e8????????           |                     

        $sequence_4 = { 51 55 ff15???????? 8b7c2410 56 8b35???????? }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   56                   | push                esi
            //   8b35????????         |                     

        $sequence_5 = { 8d542414 68???????? f3ab 52 ffd3 83c414 85c0 }
            // n = 7, score = 100
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   68????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   52                   | push                edx
            //   ffd3                 | call                ebx
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax

        $sequence_6 = { 68???????? 64a100000000 50 64892500000000 83ec08 56 33f6 }
            // n = 7, score = 100
            //   68????????           |                     
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   83ec08               | sub                 esp, 8
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi

        $sequence_7 = { c64424388d c6442439b5 c644242c81 c644242dc3 c644243e85 c644243fff }
            // n = 6, score = 100
            //   c64424388d           | mov                 byte ptr [esp + 0x38], 0x8d
            //   c6442439b5           | mov                 byte ptr [esp + 0x39], 0xb5
            //   c644242c81           | mov                 byte ptr [esp + 0x2c], 0x81
            //   c644242dc3           | mov                 byte ptr [esp + 0x2d], 0xc3
            //   c644243e85           | mov                 byte ptr [esp + 0x3e], 0x85
            //   c644243fff           | mov                 byte ptr [esp + 0x3f], 0xff

        $sequence_8 = { 8d542410 53 8944247c 53 894c2468 89542474 }
            // n = 6, score = 100
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   53                   | push                ebx
            //   8944247c             | mov                 dword ptr [esp + 0x7c], eax
            //   53                   | push                ebx
            //   894c2468             | mov                 dword ptr [esp + 0x68], ecx
            //   89542474             | mov                 dword ptr [esp + 0x74], edx

        $sequence_9 = { 8bf8 ff5204 894708 a1???????? 50 57 }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   ff5204               | call                dword ptr [edx + 4]
            //   894708               | mov                 dword ptr [edi + 8], eax
            //   a1????????           |                     
            //   50                   | push                eax
            //   57                   | push                edi

    condition:
        7 of them and filesize < 712704
}