rule win_tmanger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tmanger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tmanger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c74161d47bdb0f c741651f013f62 c74169388b8e92 c7416d9b14f6a0 }
            // n = 4, score = 200
            //   c74161d47bdb0f       | add                 edx, -0x10
            //   c741651f013f62       | mov                 byte ptr [ebp - 4], 1
            //   c74169388b8e92       | mov                 dword ptr [ebp - 0x80], 0x574eac
            //   c7416d9b14f6a0       | mov                 esi, dword ptr [ebp - 0x64]

        $sequence_1 = { c7416d9b14f6a0 c7417180fcd6bb c74175d7401d36 c7417958fffa19 }
            // n = 4, score = 200
            //   c7416d9b14f6a0       | test                esi, esi
            //   c7417180fcd6bb       | mov                 byte ptr [ebp - 4], 1
            //   c74175d7401d36       | mov                 dword ptr [ebp - 0x28], 0x574ebc
            //   c7417958fffa19       | inc                 esi

        $sequence_2 = { c7412425d933d1 c7412861fdc72a c7412cdf9134d2 c74130324d251d }
            // n = 4, score = 200
            //   c7412425d933d1       | mov                 dword ptr [ebx + 0x48], ecx
            //   c7412861fdc72a       | mov                 byte ptr [esp + 0x28], 1
            //   c7412cdf9134d2       | dec                 eax
            //   c74130324d251d       | mov                 eax, edx

        $sequence_3 = { c7415d382cd7bd c74161d47bdb0f c741651f013f62 c74169388b8e92 }
            // n = 4, score = 200
            //   c7415d382cd7bd       | lea                 eax, [ebp - 0x31c]
            //   c74161d47bdb0f       | mov                 byte ptr [ebp - 4], 1
            //   c741651f013f62       | mov                 eax, esi
            //   c74169388b8e92       | mov                 edx, dword ptr [ebp - 0x318]

        $sequence_4 = { c741651f013f62 c74169388b8e92 c7416d9b14f6a0 c7417180fcd6bb c74175d7401d36 }
            // n = 5, score = 200
            //   c741651f013f62       | mov                 eax, esi
            //   c74169388b8e92       | mov                 dword ptr [esi + 0x2d0], 0x574ebc
            //   c7416d9b14f6a0       | mov                 byte ptr [ebp - 4], 1
            //   c7417180fcd6bb       | mov                 ecx, dword ptr [ebp - 0x39c]
            //   c74175d7401d36       | mov                 ebx, eax

        $sequence_5 = { c741594d68b93a c7415d382cd7bd c74161d47bdb0f c741651f013f62 c74169388b8e92 c7416d9b14f6a0 c7417180fcd6bb }
            // n = 7, score = 200
            //   c741594d68b93a       | mov                 byte ptr [ebp - 1], 0
            //   c7415d382cd7bd       | push                eax
            //   c74161d47bdb0f       | push                edi
            //   c741651f013f62       | push                dword ptr [ebp + 0x14]
            //   c74169388b8e92       | push                dword ptr [ebp + 0x10]
            //   c7416d9b14f6a0       | mov                 byte ptr [ebp - 1], 0
            //   c7417180fcd6bb       | push                dword ptr [edi + 0x577028]

        $sequence_6 = { c74145aed72316 c74149ff663a9d c7414dd22a7e91 c741510f9f2997 c7415565449eac }
            // n = 5, score = 200
            //   c74145aed72316       | lock xadd           dword ptr [edx + 0xc], eax
            //   c74149ff663a9d       | mov                 byte ptr [ebp - 4], 1
            //   c7414dd22a7e91       | mov                 dword ptr [ebp - 0x80], 0x574eac
            //   c741510f9f2997       | mov                 esi, dword ptr [ebp - 0x64]
            //   c7415565449eac       | mov                 ecx, dword ptr [ebp - 0x68]

        $sequence_7 = { c741510f9f2997 c7415565449eac c741594d68b93a c7415d382cd7bd }
            // n = 4, score = 200
            //   c741510f9f2997       | mov                 dword ptr [ebp - 0x38], 0x574eac
            //   c7415565449eac       | xor                 ecx, ecx
            //   c741594d68b93a       | mov                 byte ptr [ebp - 4], 0
            //   c7415d382cd7bd       | mov                 dword ptr [ebp - 0x94], 0x576838

        $sequence_8 = { c7410c16d9fdf8 c741103a71c135 c74114c2a02ab0 c74118d95dc845 }
            // n = 4, score = 200
            //   c7410c16d9fdf8       | mov                 byte ptr [ecx], 0
            //   c741103a71c135       | mov                 dword ptr [ebp - 0x24], 0x5a2960
            //   c74114c2a02ab0       | mov                 dword ptr [ebp - 0x44], eax
            //   c74118d95dc845       | mov                 byte ptr [ecx], 0

        $sequence_9 = { c7412861fdc72a c7412cdf9134d2 c74130324d251d c74134375ec19d c7413893c82e55 }
            // n = 5, score = 200
            //   c7412861fdc72a       | mov                 byte ptr [ebp - 0x1c], 5
            //   c7412cdf9134d2       | mov                 dword ptr [ebp - 0x18], 0x594fd4
            //   c74130324d251d       | mov                 byte ptr [ebp - 0x14], 6
            //   c74134375ec19d       | mov                 byte ptr [ebp - 0x21], 0
            //   c7413893c82e55       | mov                 dword ptr [ebp - 0x3c], edi

    condition:
        7 of them and filesize < 8252416
}