rule win_tollbooth_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tollbooth."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tollbooth"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4885c0 0f8428010000 488d7827 4883e7e0 488947f8 4c8b442420 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4885c0               | inc                 eax
            //   0f8428010000         | push                ebx
            //   488d7827             | dec                 eax
            //   4883e7e0             | sub                 esp, 0x30
            //   488947f8             | dec                 eax
            //   4c8b442420           | mov                 ebx, ecx

        $sequence_1 = { eb67 41baa0860100 413bea 7207 bb06000000 eb55 41ba10270000 }
            // n = 7, score = 100
            //   eb67                 | movdqa              xmmword ptr [ebp + 0xa40], xmm0
            //   41baa0860100         | movdqa              xmmword ptr [ebp + 0xa40], xmm1
            //   413bea               | nop                 
            //   7207                 | dec                 esp
            //   bb06000000           | mov                 dword ptr [ebp + 0xb30], esi
            //   eb55                 | xorps               xmm0, xmm0
            //   41ba10270000         | movdqa              xmmword ptr [ebp + 0xb40], xmm0

        $sequence_2 = { 7451 488b7d07 488b4dff 48894dbf 488bd7 482bd1 48c1fa04 }
            // n = 7, score = 100
            //   7451                 | dec                 eax
            //   488b7d07             | add                 edx, 0x27
            //   488b4dff             | jb                  0x186b
            //   48894dbf             | dec                 eax
            //   488bd7               | inc                 edx
            //   482bd1               | dec                 eax
            //   48c1fa04             | mov                 ecx, dword ptr [esp + 0x530]

        $sequence_3 = { e9???????? 488d8ab8000000 e9???????? 488d8a68000000 e9???????? 488d8ad8000000 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d8ab8000000       | mov                 dword ptr [esp + 0x120], edi
            //   e9????????           |                     
            //   488d8a68000000       | dec                 eax
            //   e9????????           |                     
            //   488d8ad8000000       | mov                 dword ptr [esp + 0x130], edi
            //   e9????????           |                     

        $sequence_4 = { 4885ff 757e eb03 498bfe 807e2400 7413 e8???????? }
            // n = 7, score = 100
            //   4885ff               | mov                 dword ptr [eax + 0x10], ebx
            //   757e                 | dec                 eax
            //   eb03                 | mov                 dword ptr [eax + 0x18], 0xf
            //   498bfe               | dec                 eax
            //   807e2400             | cmp                 eax, 0x1f
            //   7413                 | ja                  0xa1b
            //   e8????????           |                     

        $sequence_5 = { 803902 7558 488b4908 488b5108 483b5110 7421 0fb645e0 }
            // n = 7, score = 100
            //   803902               | lea                 eax, [ebp - 0x19]
            //   7558                 | dec                 eax
            //   488b4908             | lea                 edx, [ebp - 0x19]
            //   488b5108             | jmp                 0xa59
            //   483b5110             | dec                 ecx
            //   7421                 | mov                 edx, eax
            //   0fb645e0             | dec                 eax

        $sequence_6 = { 48895c2450 48895c2460 48c74424680f000000 41b80a000000 488d1566350900 488d4c2450 e8???????? }
            // n = 7, score = 100
            //   48895c2450           | dec                 eax
            //   48895c2460           | mov                 ebx, ecx
            //   48c74424680f000000     | dec    eax
            //   41b80a000000         | lea                 ecx, [0x9fb81]
            //   488d1566350900       | dec                 eax
            //   488d4c2450           | mov                 dword ptr [ebx], ecx
            //   e8????????           |                     

        $sequence_7 = { 898b88000000 83bb8800000003 0f8286000000 8b8bf4160000 0fb69388000000 488b83f8160000 80ea03 }
            // n = 7, score = 100
            //   898b88000000         | or                  ebx, 2
            //   83bb8800000003       | mov                 dword ptr [esp + 0x20], ebx
            //   0f8286000000         | and                 ebx, 0xfffffffd
            //   8b8bf4160000         | mov                 dword ptr [esp + 0x20], ebx
            //   0fb69388000000       | or                  ebx, 1
            //   488b83f8160000       | and                 ebx, 0xfffffffb
            //   80ea03               | mov                 dword ptr [esp + 0x30], ebx

        $sequence_8 = { eb4d 488b8100010000 4885c0 7403 f0ff08 488d055d200300 48899900010000 }
            // n = 7, score = 100
            //   eb4d                 | mov                 ecx, ebx
            //   488b8100010000       | dec                 eax
            //   4885c0               | mov                 ebx, eax
            //   7403                 | dec                 eax
            //   f0ff08               | lea                 eax, [ebp + 0x70]
            //   488d055d200300       | nop                 
            //   48899900010000       | dec                 eax

        $sequence_9 = { 83e11f 418bd7 81c101010000 41c1ef05 83e21f 418bc7 41894d7c }
            // n = 7, score = 100
            //   83e11f               | inc                 ecx
            //   418bd7               | mov                 ecx, dword ptr [ecx + edx*4 + 0x2ca0c]
            //   81c101010000         | dec                 ecx
            //   41c1ef05             | add                 ecx, ecx
            //   83e21f               | jmp                 ecx
            //   418bc7               | dec                 ebp
            //   41894d7c             | mov                 edi, dword ptr [eax + 8]

    condition:
        7 of them and filesize < 1907712
}