rule win_tonerjam_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tonerjam."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tonerjam"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d4c2458 448d4218 ff15???????? 488d442458 c744247068000000 4889442448 }
            // n = 6, score = 100
            //   488d4c2458           | nop                 
            //   448d4218             | dec                 eax
            //   ff15????????         |                     
            //   488d442458           | sub                 ecx, edx
            //   c744247068000000     | dec                 eax
            //   4889442448           | test                edx, edx

        $sequence_1 = { 41b804010000 ff15???????? 33d2 488d8d50010000 41b804010000 }
            // n = 5, score = 100
            //   41b804010000         | mov                 eax, 0x104
            //   ff15????????         |                     
            //   33d2                 | dec                 eax
            //   488d8d50010000       | lea                 edx, [ebp + 0x270]
            //   41b804010000         | cmp                 ecx, 0x50

        $sequence_2 = { 4883ec28 e8???????? 488bc8 488d15314e0100 4883c428 e9???????? 48895c2418 }
            // n = 7, score = 100
            //   4883ec28             | jmp                 ecx
            //   e8????????           |                     
            //   488bc8               | pslldq              xmm1, 1
            //   488d15314e0100       | psrldq              xmm1, 1
            //   4883c428             | js                  0x4e9
            //   e9????????           |                     
            //   48895c2418           | mul                 ecx

        $sequence_3 = { 488d4508 458bce 4533c0 4889442420 488d1515c10100 48c7c102000080 ff15???????? }
            // n = 7, score = 100
            //   488d4508             | dec                 eax
            //   458bce               | lea                 ecx, [esp + 0x30]
            //   4533c0               | inc                 ecx
            //   4889442420           | mov                 eax, 0x800
            //   488d1515c10100       | dec                 eax
            //   48c7c102000080       | xor                 eax, esp
            //   ff15????????         |                     

        $sequence_4 = { ff15???????? 85c0 757c 48c7c0ffffffff }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   85c0                 | cmp                 dword ptr [ebp - 0x59], 0
            //   757c                 | je                  0x199
            //   48c7c0ffffffff       | cmp                 ax, 9

        $sequence_5 = { 4903c0 660f1f840000000000 8030e5 488d4001 }
            // n = 4, score = 100
            //   4903c0               | call                ebx
            //   660f1f840000000000     | test    eax, eax
            //   8030e5               | dec                 eax
            //   488d4001             | mov                 ecx, eax

        $sequence_6 = { 33d2 e8???????? 4885db 7414 488d0536d70100 483bd8 }
            // n = 6, score = 100
            //   33d2                 | lea                 edi, [0x14701]
            //   e8????????           |                     
            //   4885db               | jmp                 0x1cb4
            //   7414                 | dec                 eax
            //   488d0536d70100       | lea                 edi, [0x146e0]
            //   483bd8               | dec                 eax

        $sequence_7 = { 33c9 ff15???????? cc b801000000 488b8c2430010000 4833cc e8???????? }
            // n = 7, score = 100
            //   33c9                 | inc                 sp
            //   ff15????????         |                     
            //   cc                   | mov                 dword ptr [edx], eax
            //   b801000000           | dec                 eax
            //   488b8c2430010000     | dec                 ecx
            //   4833cc               | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { c3 397c2440 488b5c2448 400f95c7 8bc7 }
            // n = 5, score = 100
            //   c3                   | dec                 eax
            //   397c2440             | mov                 ecx, eax
            //   488b5c2448           | dec                 eax
            //   400f95c7             | mov                 esi, eax
            //   8bc7                 | dec                 esp

        $sequence_9 = { 488d0dbac10100 e8???????? 48c7c3ffffffff 488d8d70020000 488bc3 0f1f4000 48ffc0 }
            // n = 7, score = 100
            //   488d0dbac10100       | call                ebx
            //   e8????????           |                     
            //   48c7c3ffffffff       | test                eax, eax
            //   488d8d70020000       | inc                 ebp
            //   488bc3               | movzx               eax, word ptr [ecx + edx]
            //   0f1f4000             | inc                 bp
            //   48ffc0               | test                eax, eax

    condition:
        7 of them and filesize < 315392
}