rule win_topinambour_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.topinambour."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.topinambour"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2b1d 09 1106 1107 }
            // n = 4, score = 100
            //   2b1d                 | pop                 es
            //   09                   | add                 byte ptr [eax], al
            //   1106                 | or                  cl, byte ptr [ebx]
            //   1107                 | pop                 es

        $sequence_1 = { 02 282100000a 6f2200000a 25 6f1d00000a 16 6f2300000a }
            // n = 7, score = 100
            //   02                   | cmp                 cl, bh
            //   282100000a           | add                 byte ptr [eax], al
            //   6f2200000a           | add                 byte ptr [edx], dl
            //   25                   | add                 byte ptr [edx + 0x45], dh
            //   6f1d00000a           | add                 byte ptr [eax], al
            //   16                   | jo                  0x9b
            //   6f2300000a           | and                 byte ptr [eax], al

        $sequence_2 = { 1105 8d0f000001 1306 16 1307 }
            // n = 5, score = 100
            //   1105                 | add                 byte ptr [eax], al
            //   8d0f000001           | or                  ah, byte ptr [esi]
            //   1306                 | or                  dword ptr [ecx], ecx
            //   16                   | adc                 dword ptr [edx], ecx
            //   1307                 | outsd               dx, dword ptr [esi]

        $sequence_3 = { 6f1d00000a 7245000070 6f2000000a 25 6f1d00000a 7255000070 02 }
            // n = 7, score = 100
            //   6f1d00000a           | cmp                 cl, bh
            //   7245000070           | add                 byte ptr [eax], al
            //   6f2000000a           | add                 byte ptr [edi + 5], ch
            //   25                   | add                 byte ptr [eax], al
            //   6f1d00000a           | or                  ch, byte ptr [edi + 6]
            //   7255000070           | add                 byte ptr [eax], al
            //   02                   | or                  cl, byte ptr [edx]

        $sequence_4 = { 20204e0000 6f0c00000a 09 2060ea0000 6f0d00000a }
            // n = 5, score = 100
            //   20204e0000           | add                 byte ptr [edx], cl
            //   6f0c00000a           | adc                 ecx, dword ptr [ebx]
            //   09                   | adc                 dword ptr [ebx], ecx
            //   2060ea0000           | sub                 al, 0xd
            //   6f0d00000a           | push                ss

        $sequence_5 = { 25 721d000070 6f0500000a 25 }
            // n = 4, score = 100
            //   25                   | or                  dl, byte ptr [edi]
            //   721d000070           | outsd               dx, dword ptr [esi]
            //   6f0500000a           | pop                 ds
            //   25                   | add                 byte ptr [eax], al

        $sequence_6 = { 730900000a 0c 6f0a00000a 17 1c 730b00000a }
            // n = 6, score = 100
            //   730900000a           | jo                  0xb8
            //   0c                   | sbb                 eax, 0x720a0000
            //   6f0a00000a           | push                ebp
            //   17                   | add                 byte ptr [eax], al
            //   1c                   | jo                  0x55
            //   730b00000a           | sub                 byte ptr [ecx], ah

        $sequence_7 = { 25 6f1d00000a 7255000070 02 282100000a }
            // n = 5, score = 100
            //   25                   | dec                 esi
            //   6f1d00000a           | add                 byte ptr [eax], al
            //   7255000070           | and                 byte ptr [eax], ah
            //   02                   | dec                 esi
            //   282100000a           | add                 byte ptr [eax], al

        $sequence_8 = { 2e06 731000000a 7a 1104 16 }
            // n = 5, score = 100
            //   2e06                 | or                  dword ptr [edi + 0x18], ebp
            //   731000000a           | add                 byte ptr [eax], al
            //   7a                   | or                  ah, byte ptr [esi]
            //   1104                 | or                  dword ptr [edi + 0x19], ebp
            //   16                   | add                 byte ptr [eax], al

        $sequence_9 = { 6f1400000a 2802000006 1308 281300000a 1108 6f1500000a }
            // n = 6, score = 100
            //   6f1400000a           | add                 byte ptr [eax], al
            //   2802000006           | or                  cl, byte ptr [edx]
            //   1308                 | outsd               dx, dword ptr [esi]
            //   281300000a           | add                 eax, 0x6f0a0000
            //   1108                 | push                es
            //   6f1500000a           | add                 byte ptr [eax], al

    condition:
        7 of them and filesize < 50176
}