rule win_tor_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tor_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tor_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 90 eb25 4839c8 0f831a030000 4c8d5001 4c39d1 0f8602030000 }
            // n = 7, score = 100
            //   90                   | dec                 eax
            //   eb25                 | lea                 edx, [0x1799aa]
            //   4839c8               | dec                 eax
            //   0f831a030000         | mov                 dword ptr [esp + 0x48], edx
            //   4c8d5001             | dec                 eax
            //   4c39d1               | mov                 esi, dword ptr [ebx + 0xf0]
            //   0f8602030000         | dec                 eax

        $sequence_1 = { bf03000000 488d358e732800 e8???????? 0fb6542447 488b7c2460 4c8b442458 4889c6 }
            // n = 7, score = 100
            //   bf03000000           | jge                 0x2017
            //   488d358e732800       | test                byte ptr [eax], al
            //   e8????????           |                     
            //   0fb6542447           | movzx               edi, byte ptr [edx + ebx]
            //   488b7c2460           | dec                 eax
            //   4c8b442458           | mov                 edi, dword ptr [esp + 0xf8]
            //   4889c6               | dec                 eax

        $sequence_2 = { eb0f 488b442438 c6808800000001 4889c7 ba01000000 e9???????? 81fa2251f4eb }
            // n = 7, score = 100
            //   eb0f                 | dec                 eax
            //   488b442438           | mov                 ebx, eax
            //   c6808800000001       | dec                 eax
            //   4889c7               | lea                 eax, [0x3138a3]
            //   ba01000000           | dec                 eax
            //   e9????????           |                     
            //   81fa2251f4eb         | mov                 ebp, dword ptr [esp + 0x28]

        $sequence_3 = { 7659 488b842428010000 488b9c2430010000 488b9424f0000000 488b0a 488b7a08 488b7210 }
            // n = 7, score = 100
            //   7659                 | dec                 eax
            //   488b842428010000     | mov                 ecx, dword ptr [esp + 0x280]
            //   488b9c2430010000     | dec                 eax
            //   488b9424f0000000     | mov                 dword ptr [eax + 0x10], 0x10
            //   488b0a               | dec                 eax
            //   488b7a08             | lea                 ecx, [0x2d0447]
            //   488b7210             | dec                 eax

        $sequence_4 = { eb29 4889d3 4889c1 4889f0 e8???????? 488b542448 488bb424d0000000 }
            // n = 7, score = 100
            //   eb29                 | dec                 eax
            //   4889d3               | lea                 ebp, [esp + 0x98]
            //   4889c1               | dec                 eax
            //   4889f0               | mov                 dword ptr [esp + 0xc0], edi
            //   e8????????           |                     
            //   488b542448           | dec                 eax
            //   488bb424d0000000     | mov                 dword ptr [esp + 0xa8], eax

        $sequence_5 = { ebd4 833d????????00 750d 48c705????????00000000 eb0e 488d3dfc515b00 31c9 }
            // n = 7, score = 100
            //   ebd4                 | mov                 eax, dword ptr [esp + 0x38]
            //   833d????????00       |                     
            //   750d                 | mov                 byte ptr [esp + eax + 0x50], bl
            //   48c705????????00000000     |     
            //   eb0e                 | dec                 eax
            //   488d3dfc515b00       | mov                 esi, edx
            //   31c9                 | dec                 eax

        $sequence_6 = { eb23 488d056b4d6100 31db 488b6c2410 4883c418 c3 0fb75052 }
            // n = 7, score = 100
            //   eb23                 | dec                 eax
            //   488d056b4d6100       | inc                 edx
            //   31db                 | dec                 esp
            //   488b6c2410           | mov                 ecx, dword ptr [esp + 0xc8]
            //   4883c418             | dec                 esp
            //   c3                   | mov                 edx, dword ptr [esp + 0xd8]
            //   0fb75052             | dec                 eax

        $sequence_7 = { eb09 4889c7 90 e8???????? 488d0554112200 488b5c2428 488d0d86392700 }
            // n = 7, score = 100
            //   eb09                 | dec                 eax
            //   4889c7               | lea                 edi, [eax + 0x18]
            //   90                   | dec                 eax
            //   e8????????           |                     
            //   488d0554112200       | lea                 edi, [eax + 8]
            //   488b5c2428           | dec                 eax
            //   488d0d86392700       | mov                 edx, dword ptr [esp + 0x68]

        $sequence_8 = { 48c7400813000000 488d0deaf90a00 488908 488b4c2410 48894810 4889c3 488d05ad3e0500 }
            // n = 7, score = 100
            //   48c7400813000000     | mov                 dword ptr [esp + 0x68], edx
            //   488d0deaf90a00       | dec                 esp
            //   488908               | mov                 eax, eax
            //   488b4c2410           | dec                 eax
            //   48894810             | mov                 ecx, edi
            //   4889c3               | dec                 eax
            //   488d05ad3e0500       | mov                 edi, ebx

        $sequence_9 = { bf04000000 e8???????? 6690 4883fb01 7509 80382d 7504 }
            // n = 7, score = 100
            //   bf04000000           | lea                 eax, [0x33640c]
            //   e8????????           |                     
            //   6690                 | mov                 ebx, 6
            //   4883fb01             | nop                 dword ptr [eax + eax]
            //   7509                 | dec                 eax
            //   80382d               | mov                 eax, dword ptr [esp + 0x10]
            //   7504                 | dec                 eax

    condition:
        7 of them and filesize < 13050880
}