rule win_torisma_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.torisma."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.torisma"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 3d83490000 7507 b883490000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   3d83490000           | cmp                 eax, 0x4983
            //   7507                 | jne                 9
            //   b883490000           | mov                 eax, 0x4983

        $sequence_1 = { 7402 eb05 e9???????? b833280000 }
            // n = 4, score = 200
            //   7402                 | je                  4
            //   eb05                 | jmp                 7
            //   e9????????           |                     
            //   b833280000           | mov                 eax, 0x2833

        $sequence_2 = { e8???????? 3d514b0000 7504 33c0 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   3d514b0000           | cmp                 eax, 0x4b51
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 8b3f c1ef02 83e701 c1e702 }
            // n = 4, score = 100
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   c1ef02               | shr                 edi, 2
            //   83e701               | and                 edi, 1
            //   c1e702               | shl                 edi, 2

        $sequence_4 = { 488b4c2440 e8???????? 488b442460 488b4018 48c70000000000 }
            // n = 5, score = 100
            //   488b4c2440           | mov                 dword ptr [esp + 0x20], 0
            //   e8????????           |                     
            //   488b442460           | shl                 ecx, 4
            //   488b4018             | mov                 edx, dword ptr [esp + 0x12c]
            //   48c70000000000       | or                  edx, ecx

        $sequence_5 = { 488b00 488b7820 33c0 b920000000 }
            // n = 4, score = 100
            //   488b00               | dec                 eax
            //   488b7820             | mov                 eax, dword ptr [eax]
            //   33c0                 | dec                 eax
            //   b920000000           | mov                 edi, dword ptr [eax + 0x20]

        $sequence_6 = { 48894c2408 57 4883ec40 48c744242000000000 }
            // n = 4, score = 100
            //   48894c2408           | xor                 eax, eax
            //   57                   | mov                 ecx, 0x20
            //   4883ec40             | dec                 eax
            //   48c744242000000000     | mov    dword ptr [esp + 8], ecx

        $sequence_7 = { ff2495c0d50010 8bc7 ba03000000 83e904 }
            // n = 4, score = 100
            //   ff2495c0d50010       | jmp                 dword ptr [edx*4 + 0x1000d5c0]
            //   8bc7                 | mov                 eax, edi
            //   ba03000000           | mov                 edx, 3
            //   83e904               | sub                 ecx, 4

        $sequence_8 = { 837c242000 7504 33c0 eb23 }
            // n = 4, score = 100
            //   837c242000           | mov                 ecx, edx
            //   7504                 | dec                 eax
            //   33c0                 | mov                 ecx, dword ptr [esp + 0x40]
            //   eb23                 | dec                 eax

        $sequence_9 = { 894dec 6a00 ff15???????? 8d55dc 52 }
            // n = 5, score = 100
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d55dc               | lea                 edx, [ebp - 0x24]
            //   52                   | push                edx

        $sequence_10 = { 51 8b5510 52 6a25 6a20 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   6a25                 | push                0x25
            //   6a20                 | push                0x20

        $sequence_11 = { 6a02 8b4da4 8b11 52 }
            // n = 4, score = 100
            //   6a02                 | push                2
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   52                   | push                edx

        $sequence_12 = { c1e104 8b94242c010000 0bd1 8bca }
            // n = 4, score = 100
            //   c1e104               | push                edi
            //   8b94242c010000       | dec                 eax
            //   0bd1                 | sub                 esp, 0x40
            //   8bca                 | dec                 eax

    condition:
        7 of them and filesize < 322560
}