rule win_torrentlocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.torrentlocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.torrentlocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 83f801 7405 83f802 }
            // n = 4, score = 500
            //   c3                   | ret                 
            //   83f801               | cmp                 eax, 1
            //   7405                 | je                  7
            //   83f802               | cmp                 eax, 2

        $sequence_1 = { 6a01 68???????? ff15???????? 85c0 7510 6a78 50 }
            // n = 7, score = 400
            //   6a01                 | push                1
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12
            //   6a78                 | push                0x78
            //   50                   | push                eax

        $sequence_2 = { 6a02 e8???????? 83c430 85c0 }
            // n = 4, score = 400
            //   6a02                 | push                2
            //   e8????????           |                     
            //   83c430               | add                 esp, 0x30
            //   85c0                 | test                eax, eax

        $sequence_3 = { 41 81f9f1ff0000 7206 81e9f1ff0000 }
            // n = 4, score = 400
            //   41                   | inc                 ecx
            //   81f9f1ff0000         | cmp                 ecx, 0xfff1
            //   7206                 | jb                  8
            //   81e9f1ff0000         | sub                 ecx, 0xfff1

        $sequence_4 = { 6a03 e8???????? 83c410 83f8ff 7404 a810 }
            // n = 6, score = 400
            //   6a03                 | push                3
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   83f8ff               | cmp                 eax, -1
            //   7404                 | je                  6
            //   a810                 | test                al, 0x10

        $sequence_5 = { 6685d2 75f1 8bcf 8bf7 668b11 83c102 }
            // n = 6, score = 400
            //   6685d2               | test                dx, dx
            //   75f1                 | jne                 0xfffffff3
            //   8bcf                 | mov                 ecx, edi
            //   8bf7                 | mov                 esi, edi
            //   668b11               | mov                 dx, word ptr [ecx]
            //   83c102               | add                 ecx, 2

        $sequence_6 = { 7526 68400000f0 50 6a00 6a00 }
            // n = 5, score = 400
            //   7526                 | jne                 0x28
            //   68400000f0           | push                0xf0000040
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_7 = { 51 52 50 ff15???????? 85c0 7519 }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7519                 | jne                 0x1b

        $sequence_8 = { 7415 81f9340000c0 7407 85c9 750e 33c0 }
            // n = 6, score = 400
            //   7415                 | je                  0x17
            //   81f9340000c0         | cmp                 ecx, 0xc0000034
            //   7407                 | je                  9
            //   85c9                 | test                ecx, ecx
            //   750e                 | jne                 0x10
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { 85c0 740a c705????????ffffffff 8b15???????? 6a00 6a01 }
            // n = 6, score = 400
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   c705????????ffffffff     |     
            //   8b15????????         |                     
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_10 = { 56 6a00 52 ff15???????? 5e 8bc7 }
            // n = 6, score = 400
            //   56                   | push                esi
            //   6a00                 | push                0
            //   52                   | push                edx
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   8bc7                 | mov                 eax, edi

        $sequence_11 = { 751f ff15???????? 3d16000980 753d 68080000f0 }
            // n = 5, score = 400
            //   751f                 | jne                 0x21
            //   ff15????????         |                     
            //   3d16000980           | cmp                 eax, 0x80090016
            //   753d                 | jne                 0x3f
            //   68080000f0           | push                0xf0000008

        $sequence_12 = { 6a18 6a00 6a00 68???????? ffd6 83f801 7526 }
            // n = 7, score = 400
            //   6a18                 | push                0x18
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   83f801               | cmp                 eax, 1
            //   7526                 | jne                 0x28

        $sequence_13 = { 750b 68???????? ff15???????? 8bc3 }
            // n = 4, score = 400
            //   750b                 | jne                 0xd
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bc3                 | mov                 eax, ebx

        $sequence_14 = { 51 ff15???????? c705????????00000000 eb39 8b15???????? 6a0c }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   c705????????00000000     |     
            //   eb39                 | jmp                 0x3b
            //   8b15????????         |                     
            //   6a0c                 | push                0xc

        $sequence_15 = { 8bc6 5e 5f c3 be04000000 }
            // n = 5, score = 400
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   be04000000           | mov                 esi, 4

    condition:
        7 of them and filesize < 933888
}