rule win_touchmove_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.touchmove."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.touchmove"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d9520030000 488bcb 488905???????? ff15???????? }
            // n = 4, score = 100
            //   488d9520030000       | dec                 eax
            //   488bcb               | mov                 ecx, dword ptr [ecx + eax*8]
            //   488905????????       |                     
            //   ff15????????         |                     

        $sequence_1 = { c7853417000073686f74 c6853817000000 e8???????? 488d8d30290000 }
            // n = 4, score = 100
            //   c7853417000073686f74     | xor    edx, edx
            //   c6853817000000       | dec                 eax
            //   e8????????           |                     
            //   488d8d30290000       | lea                 ecx, [ebp + 0x4881]

        $sequence_2 = { c785883b0000ef911211 c7858c3b0000ff7559a3 c785903b0000e16ea064 c785943b0000b8788977 c785983b0000a0379158 }
            // n = 5, score = 100
            //   c785883b0000ef911211     | dec    eax
            //   c7858c3b0000ff7559a3     | mov    dword ptr [esp + 0x78], ebp
            //   c785903b0000e16ea064     | sar    eax, 4
            //   c785943b0000b8788977     | dec    esp
            //   c785983b0000a0379158     | arpl    ax, si

        $sequence_3 = { 894720 488d05fdfdffff 48894728 488d0502feffff 48894730 488d0507feffff }
            // n = 6, score = 100
            //   894720               | dec                 eax
            //   488d05fdfdffff       | mov                 eax, ecx
            //   48894728             | and                 ecx, 0x1f
            //   488d0502feffff       | dec                 eax
            //   48894730             | sar                 eax, 5
            //   488d0507feffff       | dec                 eax

        $sequence_4 = { 4c8d05d4acffff 89542420 83fa05 7d15 4863ca }
            // n = 5, score = 100
            //   4c8d05d4acffff       | mov                 dword ptr [ebp + 0x328], 0x636f6c6c
            //   89542420             | mov                 word ptr [ebp + 0x32c], 0x7845
            //   83fa05               | inc                 ecx
            //   7d15                 | mov                 eax, 0xf2
            //   4863ca               | dec                 eax

        $sequence_5 = { 7577 c744246000010000 488d442460 4889442428 488d8580440000 4889442420 }
            // n = 6, score = 100
            //   7577                 | inc                 ebp
            //   c744246000010000     | mov                 eax, esi
            //   488d442460           | mov                 edx, 0x80000000
            //   4889442428           | dec                 eax
            //   488d8580440000       | lea                 ecx, [ebp + 0x4d90]
            //   4889442420           | dec                 eax

        $sequence_6 = { c785200a00006b65726e c785240a0000656c3332 c785280a00002e646c6c c6852c0a000000 e8???????? }
            // n = 5, score = 100
            //   c785200a00006b65726e     | dec    eax
            //   c785240a0000656c3332     | lea    edx, [ebp + 0x3f80]
            //   c785280a00002e646c6c     | dec    eax
            //   c6852c0a000000       | mov                 ecx, 0x80000002
            //   e8????????           |                     

        $sequence_7 = { 488bdf 4889742430 4d8d570c 4c89642428 488d2d1f660100 492bdf 0f1f4000 }
            // n = 7, score = 100
            //   488bdf               | movdqa              xmmword ptr [ebp + 0x2320], xmm5
            //   4889742430           | xor                 edx, edx
            //   4d8d570c             | inc                 ecx
            //   4c89642428           | mov                 eax, 0xee
            //   488d2d1f660100       | dec                 eax
            //   492bdf               | lea                 ecx, [ebp + 0x2332]
            //   0f1f4000             | movdqa              xmmword ptr [ebp + 0x2420], xmm5

        $sequence_8 = { 83e001 894720 488d05fdfdffff 48894728 488d0502feffff }
            // n = 5, score = 100
            //   83e001               | dec                 eax
            //   894720               | not                 ecx
            //   488d05fdfdffff       | dec                 eax
            //   48894728             | dec                 ecx
            //   488d0502feffff       | dec                 eax

        $sequence_9 = { 66c785904000006572 c6859240000000 33d2 41b8ed000000 488d8d93400000 e8???????? 660f6f2d???????? }
            // n = 7, score = 100
            //   66c785904000006572     | mov    word ptr [ebp + 0x1b34], 0x73
            //   c6859240000000       | xor                 edx, edx
            //   33d2                 | movdqa              xmmword ptr [ebp + 0x1c20], xmm5
            //   41b8ed000000         | inc                 ecx
            //   488d8d93400000       | mov                 eax, 0xec
            //   e8????????           |                     
            //   660f6f2d????????     |                     

    condition:
        7 of them and filesize < 224256
}