rule win_toughprogress_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.toughprogress."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.toughprogress"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48b93448af150d8462e4 4801c8 4c89e1 ffd0 488b05???????? 48b93b8ce2c7a3ecddc7 488b0408 }
            // n = 7, score = 100
            //   48b93448af150d8462e4     | call    eax
            //   4801c8               | inc                 ecx
            //   4c89e1               | mov                 dword ptr [esi + 0x40], eax
            //   ffd0                 | dec                 eax
            //   488b05????????       |                     
            //   48b93b8ce2c7a3ecddc7     | mov    ecx, dword ptr [ebp + 0x100]
            //   488b0408             | dec                 eax

        $sequence_1 = { ffd7 0f104508 0f104d18 0f105524 410f1154244c 410f114c2440 410f11442430 }
            // n = 7, score = 100
            //   ffd7                 | fcom                dword ptr [ebx + 0x1f]
            //   0f104508             | add                 cl, byte ptr [eax + 1]
            //   0f104d18             | enter               -0x45b8, 0x14
            //   0f105524             | xor                 bl, byte ptr [edi - 0x2c9b7327]
            //   410f1154244c         | push                cs
            //   410f114c2440         | dec                 eax
            //   410f11442430         | lea                 ecx, [0x132f4d]

        $sequence_2 = { 48b93f5d14dd8256b94f 488b0408 4c01e8 4c89f9 4889fa 4189e8 ffd0 }
            // n = 7, score = 100
            //   48b93f5d14dd8256b94f     | dec    eax
            //   488b0408             | mov                 ecx, 0x66606868
            //   4c01e8               | pop                 esp
            //   4c89f9               | mov                 ecx, 0xba485211
            //   4889fa               | dec                 ecx
            //   4189e8               | mov                 esp, ecx
            //   ffd0                 | dec                 eax

        $sequence_3 = { ffd0 898688000000 488d8e8c000000 488b05???????? 48bab6b1569bc6a2bb92 48033c10 ffd7 }
            // n = 7, score = 100
            //   ffd0                 | mov                 byte ptr [ebp + 0x1bb], bl
            //   898688000000         | dec                 eax
            //   488d8e8c000000       | add                 esp, 0x38
            //   488b05????????       |                     
            //   48bab6b1569bc6a2bb92     | pop    ebx
            //   48033c10             | pop                 edi
            //   ffd7                 | pop                 esi

        $sequence_4 = { bd05000000 8d42cf 49bee5819fecd253eebe 83f809 0f8364020000 49bfdd819fecd253eebe 0f1f440000 }
            // n = 7, score = 100
            //   bd05000000           | add                 byte ptr [ebx + ecx*4 + 0x7d], cl
            //   8d42cf               | call                0x49f98bdb
            //   49bee5819fecd253eebe     | mov    eax, eax
            //   83f809               | inc                 ecx
            //   0f8364020000         | call                ecx
            //   49bfdd819fecd253eebe     | dec    ecx
            //   0f1f440000           | mov                 esp, eax

        $sequence_5 = { 4989d3 4983e307 7420 4531d2 6690 420fbe3c11 66418938 }
            // n = 7, score = 100
            //   4989d3               | dec                 ecx
            //   4983e307             | mul                 edx
            //   7420                 | dec                 eax
            //   4531d2               | shr                 edx, 2
            //   6690                 | dec                 ecx
            //   420fbe3c11           | mov                 eax, edx
            //   66418938             | inc                 ebp

        $sequence_6 = { 56 4883ec20 4889ce 488b05???????? 48b90d1dc3fe89299d3f 48ba098af7fc2873d775 48031408 }
            // n = 7, score = 100
            //   56                   | xor                 eax, eax
            //   4883ec20             | nop                 dword ptr [eax + eax]
            //   4889ce               | inc                 esp
            //   488b05????????       |                     
            //   48b90d1dc3fe89299d3f     | movzx    eax, byte ptr [edx + eax]
            //   48ba098af7fc2873d775     | push    ebp
            //   48031408             | push                ebx

        $sequence_7 = { 884101 440fb64202 4489c0 34e2 4420c0 4189c1 4180e1fa }
            // n = 7, score = 100
            //   884101               | mov                 byte ptr [ecx + 2], al
            //   440fb64202           | mov                 byte ptr [ecx], al
            //   4489c0               | movzx               eax, byte ptr [edx + 1]
            //   34e2                 | xor                 al, byte ptr [edx + 0x1a]
            //   4420c0               | mov                 byte ptr [ecx + 1], al
            //   4189c1               | movzx               eax, byte ptr [edx + 2]
            //   4180e1fa             | xor                 al, byte ptr [edx + 0x1b]

        $sequence_8 = { 84c0 0f85b2030000 488b07 4c8b36 0fb64f08 baffffffff 41baffffffff }
            // n = 7, score = 100
            //   84c0                 | dec                 esp
            //   0f85b2030000         | mov                 dword ptr [esp + 0x48], edi
            //   488b07               | dec                 ebx
            //   4c8b36               | mov                 eax, dword ptr [esi + edi*8]
            //   0fb64f08             | dec                 eax
            //   baffffffff           | mov                 dword ptr [esp + 0x38], eax
            //   41baffffffff         | test                al, al

        $sequence_9 = { 4d89c6 4889d6 488b05???????? 49b89bc488db85ad3022 48baadb54d2cbea5f70f 4a8b0400 4801d0 }
            // n = 7, score = 100
            //   4d89c6               | cmp                 bh, byte ptr [eax + 0x72]
            //   4889d6               | mov                 ebx, 0xb97bbf49
            //   488b05????????       |                     
            //   49b89bc488db85ad3022     | inc    ebx
            //   48baadb54d2cbea5f70f     | je    0x70
            //   4a8b0400             | cld                 
            //   4801d0               | xor                 edx, dword ptr [ebp + 0x8048b48]

    condition:
        7 of them and filesize < 3117056
}