rule win_treasurehunter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.treasurehunter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.treasurehunter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 56 57 6a01 6a00 e8???????? }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_1 = { 6800000020 6a2f 68???????? 57 ff15???????? 85c0 }
            // n = 6, score = 300
            //   6800000020           | push                0x20000000
            //   6a2f                 | push                0x2f
            //   68????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 8a0e 46 84c9 75f9 2bf0 e8???????? }
            // n = 6, score = 300
            //   8a0e                 | mov                 cl, byte ptr [esi]
            //   46                   | inc                 esi
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bf0                 | sub                 esi, eax
            //   e8????????           |                     

        $sequence_3 = { 56 57 8bf9 8bca e8???????? 8b7508 }
            // n = 6, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   8bca                 | mov                 ecx, edx
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_4 = { 53 56 8b35???????? 8bd9 8b4d08 57 8955fc }
            // n = 7, score = 300
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   8bd9                 | mov                 ebx, ecx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_5 = { 8bf1 85d2 7e0b 4a e8???????? 0fafc6 5e }
            // n = 7, score = 300
            //   8bf1                 | mov                 esi, ecx
            //   85d2                 | test                edx, edx
            //   7e0b                 | jle                 0xd
            //   4a                   | dec                 edx
            //   e8????????           |                     
            //   0fafc6               | imul                eax, esi
            //   5e                   | pop                 esi

        $sequence_6 = { 8903 ff15???????? 8b4dfc 57 }
            // n = 4, score = 300
            //   8903                 | mov                 dword ptr [ebx], eax
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   57                   | push                edi

        $sequence_7 = { 6800040000 8d85fcfbffff 50 8d85fcf7ffff 50 e8???????? }
            // n = 6, score = 300
            //   6800040000           | push                0x400
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]
            //   50                   | push                eax
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 229376
}