rule win_trickbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.trickbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.trickbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 1bc0 83e020 83c020 eb36 }
            // n = 4, score = 4500
            //   1bc0                 | sbb                 eax, eax
            //   83e020               | and                 eax, 0x20
            //   83c020               | add                 eax, 0x20
            //   eb36                 | jmp                 0x38

        $sequence_1 = { 83c010 eb25 a900000040 7411 2500000080 f7d8 1bc0 }
            // n = 7, score = 4500
            //   83c010               | add                 eax, 0x10
            //   eb25                 | jmp                 0x27
            //   a900000040           | test                eax, 0x40000000
            //   7411                 | je                  0x13
            //   2500000080           | and                 eax, 0x80000000
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax

        $sequence_2 = { eb36 2500000080 f7d8 1bc0 83e070 83c010 eb25 }
            // n = 7, score = 4500
            //   eb36                 | jmp                 0x38
            //   2500000080           | and                 eax, 0x80000000
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e070               | and                 eax, 0x70
            //   83c010               | add                 eax, 0x10
            //   eb25                 | jmp                 0x27

        $sequence_3 = { f7d8 1bc0 83e002 83c002 eb0d 2500000080 f7d8 }
            // n = 7, score = 4500
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e002               | and                 eax, 2
            //   83c002               | add                 eax, 2
            //   eb0d                 | jmp                 0xf
            //   2500000080           | and                 eax, 0x80000000
            //   f7d8                 | neg                 eax

        $sequence_4 = { 8b07 a900000020 7429 a900000040 }
            // n = 4, score = 4300
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   a900000020           | test                eax, 0x20000000
            //   7429                 | je                  0x2b
            //   a900000040           | test                eax, 0x40000000

        $sequence_5 = { c705????????fdffffff c705????????feffffff c705????????ffffffff e8???????? }
            // n = 4, score = 3700
            //   c705????????fdffffff     |     
            //   c705????????feffffff     |     
            //   c705????????ffffffff     |     
            //   e8????????           |                     

        $sequence_6 = { 895df8 895df4 895dec 66c745f00005 895dfc }
            // n = 5, score = 3500
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   66c745f00005         | mov                 word ptr [ebp - 0x10], 0x500
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_7 = { 8902 3bcb 7507 5f 5e }
            // n = 5, score = 3400
            //   8902                 | sbb                 eax, eax
            //   3bcb                 | and                 eax, 0x70
            //   7507                 | add                 eax, 0x10
            //   5f                   | jmp                 0x2f
            //   5e                   | neg                 eax

        $sequence_8 = { 8d1489 8d0cd0 8b4114 2b410c }
            // n = 4, score = 3000
            //   8d1489               | lea                 edx, [ecx + ecx*4]
            //   8d0cd0               | lea                 ecx, [eax + edx*8]
            //   8b4114               | mov                 eax, dword ptr [ecx + 0x14]
            //   2b410c               | sub                 eax, dword ptr [ecx + 0xc]

        $sequence_9 = { 41 83c028 3bce 7ce9 }
            // n = 4, score = 3000
            //   41                   | inc                 ecx
            //   83c028               | add                 eax, 0x28
            //   3bce                 | cmp                 ecx, esi
            //   7ce9                 | jl                  0xffffffeb

        $sequence_10 = { 1bc0 83e007 40 8b4fe8 }
            // n = 4, score = 3000
            //   1bc0                 | sbb                 eax, eax
            //   83e007               | and                 eax, 7
            //   40                   | inc                 eax
            //   8b4fe8               | mov                 ecx, dword ptr [edi - 0x18]

        $sequence_11 = { 488b5118 4889442440 488b4148 4889442438 }
            // n = 4, score = 2800
            //   488b5118             | mov                 dword ptr [esp + 0x30], eax
            //   4889442440           | dec                 eax
            //   488b4148             | mov                 eax, dword ptr [ecx + 0x38]
            //   4889442438           | dec                 eax

        $sequence_12 = { 488b4138 4889442428 488b4130 488b4910 4889442420 41ffd2 }
            // n = 6, score = 2800
            //   488b4138             | dec                 eax
            //   4889442428           | mov                 eax, dword ptr [ecx + 0x38]
            //   488b4130             | dec                 eax
            //   488b4910             | mov                 dword ptr [esp + 0x28], eax
            //   4889442420           | dec                 eax
            //   41ffd2               | mov                 eax, dword ptr [ecx + 0x30]

        $sequence_13 = { 4c8b4120 488b5118 4889442438 488b4140 }
            // n = 4, score = 2800
            //   4c8b4120             | mov                 eax, dword ptr [ecx]
            //   488b5118             | dec                 esp
            //   4889442438           | mov                 eax, dword ptr [ecx + 0x20]
            //   488b4140             | dec                 eax

        $sequence_14 = { 488b01 4c8b4120 488b5118 488b4910 }
            // n = 4, score = 2800
            //   488b01               | mov                 edx, dword ptr [ecx + 0x18]
            //   4c8b4120             | dec                 eax
            //   488b5118             | mov                 dword ptr [esp + 0x38], eax
            //   488b4910             | dec                 eax

        $sequence_15 = { 488b01 488b5118 488b4910 ffd0 }
            // n = 4, score = 2800
            //   488b01               | mov                 dword ptr [esp + 0x38], eax
            //   488b5118             | dec                 eax
            //   488b4910             | mov                 eax, dword ptr [ecx + 0x40]
            //   ffd0                 | dec                 eax

        $sequence_16 = { 488b4148 4c8b11 4c8b4928 4c8b4120 488b5118 }
            // n = 5, score = 2800
            //   488b4148             | dec                 eax
            //   4c8b11               | mov                 eax, dword ptr [ecx + 0x48]
            //   4c8b4928             | dec                 esp
            //   4c8b4120             | mov                 edx, dword ptr [ecx]
            //   488b5118             | dec                 esp

        $sequence_17 = { 488b4148 4889442438 488b4140 4889442430 488b4138 4889442428 488b4130 }
            // n = 7, score = 2800
            //   488b4148             | mov                 edx, dword ptr [ecx + 0x18]
            //   4889442438           | dec                 eax
            //   488b4140             | mov                 eax, dword ptr [ecx + 0x48]
            //   4889442430           | dec                 esp
            //   488b4138             | mov                 edx, dword ptr [ecx]
            //   4889442428           | dec                 esp
            //   488b4130             | mov                 ecx, dword ptr [ecx + 0x28]

        $sequence_18 = { 48397c2430 0f94c3 8bc3 488b5c2450 4883c440 }
            // n = 5, score = 2500
            //   48397c2430           | add                 eax, 2
            //   0f94c3               | jmp                 0xf
            //   8bc3                 | and                 eax, 0x80000000
            //   488b5c2450           | neg                 eax
            //   4883c440             | add                 eax, 0x20

        $sequence_19 = { 6644891b 664183fb1a 7307 664183c341 eb13 }
            // n = 5, score = 2100
            //   6644891b             | dec                 esp
            //   664183fb1a           | mov                 eax, dword ptr [ecx + 0x20]
            //   7307                 | dec                 eax
            //   664183c341           | mov                 edx, dword ptr [ecx + 0x18]
            //   eb13                 | dec                 eax

        $sequence_20 = { 83780400 7404 8b4008 c3 }
            // n = 4, score = 2000
            //   83780400             | je                  0x20
            //   7404                 | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4008               | dec                 dword ptr [ebp + 0xc]
            //   c3                   | mov                 edx, 0x28

        $sequence_21 = { 2bc2 d1e8 03c2 c1e806 6bc05f }
            // n = 5, score = 2000
            //   2bc2                 | call                dword ptr [ebp + 8]
            //   d1e8                 | push                eax
            //   03c2                 | lodsw               ax, word ptr [esi]
            //   c1e806               | test                eax, eax
            //   6bc05f               | je                  0x20

        $sequence_22 = { 6820bf0200 68905f0100 68905f0100 50 }
            // n = 4, score = 2000
            //   6820bf0200           | mov                 ecx, dword ptr [edx + 0xc]
            //   68905f0100           | call                dword ptr [ebp + 8]
            //   68905f0100           | mov                 edx, dword ptr [ebp + 0x10]
            //   50                   | mov                 ecx, dword ptr [edx + 4]

        $sequence_23 = { 51 68e9fd0000 50 e8???????? }
            // n = 4, score = 1800
            //   51                   | mov                 eax, ebp
            //   68e9fd0000           | call                dword ptr [ebp + 8]
            //   50                   | pop                 eax
            //   e8????????           |                     

        $sequence_24 = { 6a40 6800300000 6a70 6a00 }
            // n = 4, score = 1800
            //   6a40                 | mov                 dword ptr [ebp + 0x14], eax
            //   6800300000           | mov                 edx, dword ptr [ebp + 0x10]
            //   6a70                 | mov                 eax, ecx
            //   6a00                 | lodsw               ax, word ptr [esi]

        $sequence_25 = { 8d440002 6a00 50 e8???????? }
            // n = 4, score = 1500
            //   8d440002             | lea                 eax, [eax + eax + 2]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_26 = { c3 6a01 ff15???????? 50 }
            // n = 4, score = 1500
            //   c3                   | ret                 
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_27 = { 85c0 7f0b e8???????? 8b05???????? }
            // n = 4, score = 1300
            //   85c0                 | mul                 edx
            //   7f0b                 | push                eax
            //   e8????????           |                     
            //   8b05????????         |                     

        $sequence_28 = { e8???????? 83f801 7411 ba0a000000 }
            // n = 4, score = 1300
            //   e8????????           |                     
            //   83f801               | pop                 ecx
            //   7411                 | call                dword ptr [ebp + 8]
            //   ba0a000000           | pop                 eax

        $sequence_29 = { 8b45f8 5f c60000 2b450c 5e }
            // n = 5, score = 1300
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   5f                   | pop                 edi
            //   c60000               | mov                 byte ptr [eax], 0
            //   2b450c               | sub                 eax, dword ptr [ebp + 0xc]
            //   5e                   | pop                 esi

        $sequence_30 = { 8b01 59 03d0 52 ebdc 89450c }
            // n = 6, score = 1200
            //   8b01                 | and                 eax, 0x20
            //   59                   | add                 eax, 0x20
            //   03d0                 | jmp                 0x3b
            //   52                   | and                 eax, 0x80000000
            //   ebdc                 | neg                 eax
            //   89450c               | add                 eax, 0x10

        $sequence_31 = { 8bc1 66ad 85c0 741c }
            // n = 4, score = 1200
            //   8bc1                 | add                 eax, 0x20
            //   66ad                 | jmp                 0x3b
            //   85c0                 | and                 eax, 0x80000000
            //   741c                 | neg                 eax

        $sequence_32 = { 50 8b450c ff4d0c ba28000000 f7e2 }
            // n = 5, score = 1200
            //   50                   | jmp                 0x27
            //   8b450c               | test                eax, 0x40000000
            //   ff4d0c               | je                  0x1a
            //   ba28000000           | and                 eax, 0x80000000
            //   f7e2                 | neg                 eax

        $sequence_33 = { 7405 e8???????? ff15???????? 8bc3 }
            // n = 4, score = 1200
            //   7405                 | mov                 dword ptr [ebp + 0x14], eax
            //   e8????????           |                     
            //   ff15????????         |                     
            //   8bc3                 | add                 edx, eax

        $sequence_34 = { ff5508 8b5510 8b4a04 ff5508 50 51 }
            // n = 6, score = 1100
            //   ff5508               | jmp                 0x27
            //   8b5510               | test                eax, 0x40000000
            //   8b4a04               | je                  0x1a
            //   ff5508               | and                 eax, 0x80000000
            //   50                   | neg                 eax
            //   51                   | sbb                 eax, eax

        $sequence_35 = { 2bc1 8b00 3bc7 72f2 }
            // n = 4, score = 1100
            //   2bc1                 | mov                 dword ptr [ebp + 0xc], eax
            //   8b00                 | mov                 eax, ebp
            //   3bc7                 | call                dword ptr [ebp + 8]
            //   72f2                 | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_36 = { ff5508 58 894514 8b5510 }
            // n = 4, score = 1100
            //   ff5508               | je                  0x18
            //   58                   | and                 eax, 0x80000000
            //   894514               | neg                 eax
            //   8b5510               | sbb                 eax, eax

        $sequence_37 = { 03d0 895510 8b4a04 ff5508 8b5510 8b4a0c }
            // n = 6, score = 1100
            //   03d0                 | jmp                 0x27
            //   895510               | test                eax, 0x40000000
            //   8b4a04               | je                  0x18
            //   ff5508               | and                 eax, 0x80000000
            //   8b5510               | neg                 eax
            //   8b4a0c               | neg                 eax

        $sequence_38 = { c1e102 2bc1 8b00 894508 }
            // n = 4, score = 1100
            //   c1e102               | and                 eax, 0x80000000
            //   2bc1                 | neg                 eax
            //   8b00                 | sbb                 eax, eax
            //   894508               | and                 eax, 0x70

        $sequence_39 = { 85c0 741c 3bc1 7213 }
            // n = 4, score = 1100
            //   85c0                 | add                 eax, 2
            //   741c                 | jmp                 0x12
            //   3bc1                 | and                 eax, 0x80000000
            //   7213                 | neg                 eax

        $sequence_40 = { 3bc1 7703 894df4 8b47fc }
            // n = 4, score = 1000
            //   3bc1                 | and                 eax, 2
            //   7703                 | add                 eax, 2
            //   894df4               | jmp                 0x12
            //   8b47fc               | neg                 eax

        $sequence_41 = { 0f8280000000 813950450000 7578 f6411602 7472 }
            // n = 5, score = 1000
            //   0f8280000000         | sbb                 eax, eax
            //   813950450000         | and                 eax, 0x70
            //   7578                 | add                 eax, 0x10
            //   f6411602             | jmp                 0x2d
            //   7472                 | test                eax, 0x40000000

        $sequence_42 = { f7e2 8d9500040000 03d0 895510 }
            // n = 4, score = 1000
            //   f7e2                 | call                dword ptr [ebp + 8]
            //   8d9500040000         | mov                 edx, dword ptr [ebp + 0x10]
            //   03d0                 | mov                 ecx, dword ptr [edx + 0xc]
            //   895510               | sub                 eax, ecx

        $sequence_43 = { c744242000300000 ff15???????? 85c0 7911 }
            // n = 4, score = 900
            //   c744242000300000     | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 ecx, dword ptr [ecx + 0x10]
            //   7911                 | call                eax

        $sequence_44 = { 790f 8bc8 e8???????? 8d5e10 }
            // n = 4, score = 900
            //   790f                 | mov                 eax, dword ptr [ecx + 0x20]
            //   8bc8                 | dec                 eax
            //   e8????????           |                     
            //   8d5e10               | mov                 edx, dword ptr [ecx + 0x18]

        $sequence_45 = { 8bcf e8???????? 8bf0 85ed }
            // n = 4, score = 900
            //   8bcf                 | call                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bf0                 | push                eax
            //   85ed                 | push                ecx

        $sequence_46 = { 7911 8bc8 e8???????? bb10000000 }
            // n = 4, score = 900
            //   7911                 | dec                 eax
            //   8bc8                 | mov                 dword ptr [esp + 0x38], eax
            //   e8????????           |                     
            //   bb10000000           | dec                 eax

        $sequence_47 = { 33c9 33d2 ff15???????? 85c0 }
            // n = 4, score = 900
            //   33c9                 | mov                 dword ptr [ebp + 0x10], edx
            //   33d2                 | mov                 ecx, dword ptr [edx + 4]
            //   ff15????????         |                     
            //   85c0                 | call                dword ptr [ebp + 8]

        $sequence_48 = { 7c22 3c39 7f1e 0fbec0 }
            // n = 4, score = 900
            //   7c22                 | dec                 eax
            //   3c39                 | mov                 dword ptr [esp + 0x40], eax
            //   7f1e                 | dec                 eax
            //   0fbec0               | mov                 eax, dword ptr [ecx + 0x48]

        $sequence_49 = { 7536 b906000000 8bc1 c3 }
            // n = 4, score = 900
            //   7536                 | dec                 eax
            //   b906000000           | mov                 edx, dword ptr [ecx + 0x18]
            //   8bc1                 | dec                 eax
            //   c3                   | mov                 dword ptr [esp + 0x40], eax

        $sequence_50 = { 58 41 41 41 41 }
            // n = 5, score = 900
            //   58                   | dec                 eax
            //   41                   | mov                 dword ptr [esp + 0x30], eax
            //   41                   | dec                 eax
            //   41                   | mov                 eax, dword ptr [ecx + 0x38]
            //   41                   | dec                 eax

        $sequence_51 = { 8bcd 84c0 742e 660f1f440000 3c30 7c22 }
            // n = 6, score = 900
            //   8bcd                 | dec                 eax
            //   84c0                 | mov                 eax, dword ptr [ecx + 0x40]
            //   742e                 | dec                 eax
            //   660f1f440000         | mov                 dword ptr [esp + 0x30], eax
            //   3c30                 | dec                 eax
            //   7c22                 | mov                 edx, dword ptr [ecx + 0x18]

        $sequence_52 = { ff15???????? 8bf0 c1ee1f 83f601 }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   8bf0                 | mov                 edx, dword ptr [ebp + 0x10]
            //   c1ee1f               | mov                 edx, dword ptr [ebp + 0x10]
            //   83f601               | mov                 ecx, dword ptr [edx + 4]

        $sequence_53 = { ff15???????? 85c0 0f89d2000000 8bc8 e8???????? }
            // n = 5, score = 900
            //   ff15????????         |                     
            //   85c0                 | mov                 eax, dword ptr [ecx + 0x40]
            //   0f89d2000000         | dec                 eax
            //   8bc8                 | mov                 dword ptr [esp + 0x30], eax
            //   e8????????           |                     

        $sequence_54 = { eb0a 83f802 742b 83f803 745b }
            // n = 5, score = 900
            //   eb0a                 | mov                 dword ptr [esp + 0x30], eax
            //   83f802               | dec                 esp
            //   742b                 | mov                 eax, dword ptr [ecx + 0x20]
            //   83f803               | dec                 eax
            //   745b                 | mov                 edx, dword ptr [ecx + 0x18]

        $sequence_55 = { 8bc8 33c0 85c9 0f95c0 eb02 }
            // n = 5, score = 800
            //   8bc8                 | mov                 ecx, dword ptr [edx + 4]
            //   33c0                 | call                dword ptr [ebp + 8]
            //   85c9                 | mov                 edx, dword ptr [ebp + 0x10]
            //   0f95c0               | mov                 ecx, dword ptr [edx + 0xc]
            //   eb02                 | call                dword ptr [ebp + 8]

        $sequence_56 = { 41 41 50 2bc1 8b00 }
            // n = 5, score = 800
            //   41                   | mov                 eax, dword ptr [ecx + 0x48]
            //   41                   | dec                 eax
            //   50                   | mov                 dword ptr [esp + 0x38], eax
            //   2bc1                 | dec                 eax
            //   8b00                 | mov                 eax, dword ptr [ecx + 0x40]

        $sequence_57 = { 2bc1 c1e002 51 8bcf }
            // n = 4, score = 600
            //   2bc1                 | dec                 eax
            //   c1e002               | mov                 dword ptr [esp + 0x30], eax
            //   51                   | dec                 eax
            //   8bcf                 | mov                 edx, dword ptr [ecx + 0x18]

        $sequence_58 = { 6a00 6a00 ff15???????? 6a00 6a00 6a00 8d45dc }
            // n = 7, score = 200
            //   6a00                 | mov                 edx, dword ptr [ebp + 0x10]
            //   6a00                 | mov                 ecx, dword ptr [edx + 4]
            //   ff15????????         |                     
            //   6a00                 | call                dword ptr [ebp + 8]
            //   6a00                 | push                eax
            //   6a00                 | push                ecx
            //   8d45dc               | push                eax

        $sequence_59 = { 8b7d10 2bf9 53 50 }
            // n = 4, score = 200
            //   8b7d10               | mov                 eax, dword ptr [ecx]
            //   2bf9                 | pop                 ecx
            //   53                   | add                 edx, eax
            //   50                   | push                edx

        $sequence_60 = { 8dbf00500310 8bd6 897d08 3bc8 }
            // n = 4, score = 200
            //   8dbf00500310         | mov                 dword ptr [ebp + 0xc], eax
            //   8bd6                 | mov                 eax, ebp
            //   897d08               | add                 edx, eax
            //   3bc8                 | mov                 dword ptr [ebp + 0x10], edx

        $sequence_61 = { 8b4d08 dd01 8b7510 dd1e e9???????? c745dce8c20001 }
            // n = 6, score = 100
            //   8b4d08               | and                 eax, 2
            //   dd01                 | add                 eax, 2
            //   8b7510               | jmp                 0xf
            //   dd1e                 | and                 eax, 0x80000000
            //   e9????????           |                     
            //   c745dce8c20001       | and                 eax, 2

        $sequence_62 = { 3302 52 8bd0 51 03cf 51 58 }
            // n = 7, score = 100
            //   3302                 | add                 edx, eax
            //   52                   | push                edx
            //   8bd0                 | jmp                 0xffffffde
            //   51                   | mov                 dword ptr [ebp + 0xc], eax
            //   03cf                 | mov                 eax, dword ptr [ecx]
            //   51                   | pop                 ecx
            //   58                   | add                 edx, eax

        $sequence_63 = { 58 8910 59 5a }
            // n = 4, score = 100
            //   58                   | push                eax
            //   8910                 | mov                 eax, dword ptr [ebp + 0xc]
            //   59                   | dec                 dword ptr [ebp + 0xc]
            //   5a                   | pop                 ecx

        $sequence_64 = { 760b 8b45d0 83e801 8945d0 }
            // n = 4, score = 100
            //   760b                 | call                dword ptr [ebp + 8]
            //   8b45d0               | pop                 eax
            //   83e801               | mov                 dword ptr [ebp + 0x14], eax
            //   8945d0               | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_65 = { 8945d4 8b4dfc 51 8b55d4 52 e8???????? 8b45fc }
            // n = 7, score = 100
            //   8945d4               | lodsw               ax, word ptr [esi]
            //   8b4dfc               | test                eax, eax
            //   51                   | je                  0x20
            //   8b55d4               | cmp                 eax, ecx
            //   52                   | jb                  0x1b
            //   e8????????           |                     
            //   8b45fc               | sub                 eax, ecx

        $sequence_66 = { 85c0 7417 817de013010000 7502 eb0c 8d45dc 50 }
            // n = 7, score = 100
            //   85c0                 | mov                 eax, dword ptr [ecx]
            //   7417                 | pop                 ecx
            //   817de013010000       | add                 edx, eax
            //   7502                 | push                edx
            //   eb0c                 | jmp                 0xffffffe1
            //   8d45dc               | mov                 dword ptr [ebp + 0xc], eax
            //   50                   | call                dword ptr [ebp + 0x14]

        $sequence_67 = { bad64abad6 4a ba5d12f75d 12f7 5d 12f7 5d }
            // n = 7, score = 100
            //   bad64abad6           | and                 eax, 0x80000000
            //   4a                   | add                 eax, 0x10
            //   ba5d12f75d           | jmp                 0x27
            //   12f7                 | test                eax, 0x40000000
            //   5d                   | je                  0x1a
            //   12f7                 | and                 eax, 0x80000000
            //   5d                   | neg                 eax

        $sequence_68 = { c705????????ad380001 8935???????? a3???????? ff15???????? a3???????? 83f8ff 0f84c1000000 }
            // n = 7, score = 100
            //   c705????????ad380001     |     
            //   8935????????         |                     
            //   a3????????           |                     
            //   ff15????????         |                     
            //   a3????????           |                     
            //   83f8ff               | add                 eax, 0x10
            //   0f84c1000000         | jmp                 0x2a

        $sequence_69 = { 51 6800300400 8b55f8 52 ff15???????? 8945fc 837dfc00 }
            // n = 7, score = 100
            //   51                   | call                dword ptr [ebp + 8]
            //   6800300400           | mov                 edx, dword ptr [ebp + 0x10]
            //   8b55f8               | mov                 ecx, dword ptr [edx + 4]
            //   52                   | call                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   8945fc               | push                eax
            //   837dfc00             | push                ecx

        $sequence_70 = { 40 8945d0 ff75fc ff75d0 }
            // n = 4, score = 100
            //   40                   | add                 edx, eax
            //   8945d0               | push                edx
            //   ff75fc               | jmp                 0xffffffdf
            //   ff75d0               | mov                 dword ptr [ebp + 0xc], eax

        $sequence_71 = { 84c0 741d 56 68???????? 8bc7 e8???????? }
            // n = 6, score = 100
            //   84c0                 | test                eax, 0x40000000
            //   741d                 | je                  0x1d
            //   56                   | add                 eax, 0x10
            //   68????????           |                     
            //   8bc7                 | jmp                 0x27
            //   e8????????           |                     

        $sequence_72 = { 8b4508 56 8d34c590f30001 833e00 7513 }
            // n = 5, score = 100
            //   8b4508               | add                 eax, 2
            //   56                   | jmp                 0x12
            //   8d34c590f30001       | and                 eax, 0x80000000
            //   833e00               | neg                 eax
            //   7513                 | and                 eax, 0x70

        $sequence_73 = { f361 34aa 61 34aa }
            // n = 4, score = 100
            //   f361                 | test                eax, 0x40000000
            //   34aa                 | and                 eax, 0x70
            //   61                   | add                 eax, 0x10
            //   34aa                 | jmp                 0x2a

        $sequence_74 = { c1e803 85c0 7414 56 57 }
            // n = 5, score = 100
            //   c1e803               | test                eax, 0x40000000
            //   85c0                 | je                  0x1a
            //   7414                 | je                  0x2b
            //   56                   | test                eax, 0x40000000
            //   57                   | je                  0x18

        $sequence_75 = { 56 ff750c 6818280300 5e 56 }
            // n = 5, score = 100
            //   56                   | push                edx
            //   ff750c               | call                dword ptr [ebp + 0x14]
            //   6818280300           | push                eax
            //   5e                   | mov                 eax, dword ptr [ebp + 0xc]
            //   56                   | dec                 dword ptr [ebp + 0xc]

        $sequence_76 = { 83c408 eb18 81ff01030000 7d10 53 53 }
            // n = 6, score = 100
            //   83c408               | and                 eax, 0x80000000
            //   eb18                 | neg                 eax
            //   81ff01030000         | sbb                 eax, eax
            //   7d10                 | and                 eax, 2
            //   53                   | add                 eax, 2
            //   53                   | jmp                 0x1e

        $sequence_77 = { 7420 8b4de0 83c101 894de0 817de014010000 }
            // n = 5, score = 100
            //   7420                 | mov                 edx, dword ptr [ebp + 0x10]
            //   8b4de0               | mov                 ecx, dword ptr [edx + 4]
            //   83c101               | call                dword ptr [ebp + 8]
            //   894de0               | push                eax
            //   817de014010000       | push                ecx

    condition:
        7 of them and filesize < 712704
}