rule win_trochilus_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.trochilus_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.trochilus_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8410010000 8b3d???????? 6894e40010 53 ffd7 85c0 0f84fa000000 }
            // n = 7, score = 100
            //   0f8410010000         | je                  0x116
            //   8b3d????????         |                     
            //   6894e40010           | push                0x1000e494
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   0f84fa000000         | je                  0x100

        $sequence_1 = { 7405 6a02 5e ebc6 e8???????? eb25 e8???????? }
            // n = 7, score = 100
            //   7405                 | je                  7
            //   6a02                 | push                2
            //   5e                   | pop                 esi
            //   ebc6                 | jmp                 0xffffffc8
            //   e8????????           |                     
            //   eb25                 | jmp                 0x27
            //   e8????????           |                     

        $sequence_2 = { 2bf9 f7df 1bff 23f8 0f849a000000 8b4708 }
            // n = 6, score = 100
            //   2bf9                 | sub                 edi, ecx
            //   f7df                 | neg                 edi
            //   1bff                 | sbb                 edi, edi
            //   23f8                 | and                 edi, eax
            //   0f849a000000         | je                  0xa0
            //   8b4708               | mov                 eax, dword ptr [edi + 8]

        $sequence_3 = { 53 57 8d4e2c 8bf8 2bf9 f7df 1bff }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8d4e2c               | lea                 ecx, [esi + 0x2c]
            //   8bf8                 | mov                 edi, eax
            //   2bf9                 | sub                 edi, ecx
            //   f7df                 | neg                 edi
            //   1bff                 | sbb                 edi, edi

        $sequence_4 = { 56 8bf1 c706d0d10010 e8???????? f6450801 7407 56 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   c706d0d10010         | mov                 dword ptr [esi], 0x1000d1d0
            //   e8????????           |                     
            //   f6450801             | test                byte ptr [ebp + 8], 1
            //   7407                 | je                  9
            //   56                   | push                esi

        $sequence_5 = { 8b4dfc 8b06 b201 d2e2 081438 663b5d0c 740e }
            // n = 7, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   b201                 | mov                 dl, 1
            //   d2e2                 | shl                 dl, cl
            //   081438               | or                  byte ptr [eax + edi], dl
            //   663b5d0c             | cmp                 bx, word ptr [ebp + 0xc]
            //   740e                 | je                  0x10

        $sequence_6 = { 50 6a06 8d85ecfbffff 50 8bcf }
            // n = 5, score = 100
            //   50                   | push                eax
            //   6a06                 | push                6
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   50                   | push                eax
            //   8bcf                 | mov                 ecx, edi

        $sequence_7 = { ff7510 8b01 ff750c ff5034 6a00 ff7508 8bfe }
            // n = 7, score = 100
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff5034               | call                dword ptr [eax + 0x34]
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bfe                 | mov                 edi, esi

        $sequence_8 = { 8bce e8???????? eba2 55 8bec 83ec0c 56 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   eba2                 | jmp                 0xffffffa4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc
            //   56                   | push                esi

        $sequence_9 = { a1???????? c705????????90897e00 8935???????? a3???????? ff15???????? a3???????? }
            // n = 6, score = 100
            //   a1????????           |                     
            //   c705????????90897e00     |     
            //   8935????????         |                     
            //   a3????????           |                     
            //   ff15????????         |                     
            //   a3????????           |                     

    condition:
        7 of them and filesize < 630784
}