rule win_troll_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.troll_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.troll_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 49895008 6699 49894010 0fb7d5 9c c0f2b0 66d3f2 }
            // n = 7, score = 100
            //   49895008             | pushfd              
            //   6699                 | mov                 ebx, ebp
            //   49894010             | inc                 ecx
            //   0fb7d5               | pop                 dword ptr [eax]
            //   9c                   | shl                 bh, cl
            //   c0f2b0               | inc                 ax
            //   66d3f2               | movsx               ebx, ch

        $sequence_1 = { d0ca 80c2f3 f9 f8 d0c2 4432ca f7c465491a38 }
            // n = 7, score = 100
            //   d0ca                 | sal                 edx, cl
            //   80c2f3               | and                 si, ax
            //   f9                   | cdq                 
            //   f8                   | and                 si, ax
            //   d0c2                 | inc                 ecx
            //   4432ca               | cmove               edx, eax
            //   f7c465491a38         | dec                 eax

        $sequence_2 = { f7d2 f9 d1c2 4153 41ffc3 311424 415b }
            // n = 7, score = 100
            //   f7d2                 | inc                 ecx
            //   f9                   | push                eax
            //   d1c2                 | stc                 
            //   4153                 | inc                 esp
            //   41ffc3               | xor                 dword ptr [esp], ecx
            //   311424               | inc                 ecx
            //   415b                 | test                ah, 0xec

        $sequence_3 = { 4181eb2315e85c 313424 458bdd 49c7c33109c930 }
            // n = 4, score = 100
            //   4181eb2315e85c       | inc                 ecx
            //   313424               | push                ebx
            //   458bdd               | inc                 sp
            //   49c7c33109c930       | movzx               ebx, bh

        $sequence_4 = { 81d9d83d744a f6d2 80c253 0fbfc8 d2cd d0c2 }
            // n = 6, score = 100
            //   81d9d83d744a         | inc                 esp
            //   f6d2                 | xor                 dword ptr [esp], ebx
            //   80c253               | inc                 eax
            //   0fbfc8               | adc                 dh, bl
            //   d2cd                 | push                esi
            //   d0c2                 | xor                 si, 0xe61

        $sequence_5 = { 313c24 480fbafbc6 c1eb14 480fb7da 5b 4863ff f8 }
            // n = 7, score = 100
            //   313c24               | dec                 eax
            //   480fbafbc6           | mov                 ebp, dword ptr [ebp - 8]
            //   c1eb14               | inc                 cx
            //   480fb7da             | bt                  edx, 0x23
            //   5b                   | inc                 eax
            //   4863ff               | ror                 bh, 0x5c
            //   f8                   | call                eax

        $sequence_6 = { 453bf3 4153 311424 664181eb996f 415b f9 4863d2 }
            // n = 7, score = 100
            //   453bf3               | or                  al, 0x54
            //   4153                 | dec                 ecx
            //   311424               | sub                 edx, 4
            //   664181eb996f         | btc                 eax, esp
            //   415b                 | sar                 ax, cl
            //   f9                   | inc                 ecx
            //   4863d2               | mov                 eax, dword ptr [edx]

        $sequence_7 = { 4d8d141a 48bd0000000002000000 4d8d142a 410fc1f9 4c8bc4 4881ec80010000 450fbfc8 }
            // n = 7, score = 100
            //   4d8d141a             | cmp                 cl, dh
            //   48bd0000000002000000     | dec    eax
            //   4d8d142a             | lea                 eax, [eax + edx]
            //   410fc1f9             | cmc                 
            //   4c8bc4               | dec                 eax
            //   4881ec80010000       | mov                 dword ptr [ebp - 8], eax
            //   450fbfc8             | dec                 eax

        $sequence_8 = { 403ad4 81f6a540bf26 f7d6 f5 d1c6 f8 f7d6 }
            // n = 7, score = 100
            //   403ad4               | test                edi, edi
            //   81f6a540bf26         | cmc                 
            //   f7d6                 | inc                 ecx
            //   f5                   | xor                 eax, ebx
            //   d1c6                 | cmc                 
            //   f8                   | seto                dh
            //   f7d6                 | inc                 ecx

        $sequence_9 = { 4112eb 418910 4080dd61 40fec5 660bef 418b2b 4981c304000000 }
            // n = 7, score = 100
            //   4112eb               | pop                 esi
            //   418910               | inc                 ax
            //   4080dd61             | movsx               eax, ch
            //   40fec5               | dec                 eax
            //   660bef               | cmovle              eax, edx
            //   418b2b               | inc                 eax
            //   4981c304000000       | setle               bh

    condition:
        7 of them and filesize < 45868032
}