rule win_tuoni_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tuoni."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tuoni"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 84c0 7427 3c07 7423 8b4108 c6401c01 c7401816000000 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   7427                 | je                  0x29
            //   3c07                 | cmp                 al, 7
            //   7423                 | je                  0x25
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   c6401c01             | mov                 byte ptr [eax + 0x1c], 1
            //   c7401816000000       | mov                 dword ptr [eax + 0x18], 0x16

        $sequence_1 = { 894604 e8???????? 894604 8bc6 59 e8???????? c20400 }
            // n = 7, score = 100
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   e8????????           |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   8bc6                 | mov                 eax, esi
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   c20400               | ret                 4

        $sequence_2 = { e8???????? b8???????? e9???????? 8d4dd8 e9???????? 8b45d0 83e001 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b8????????           |                     
            //   e9????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e9????????           |                     
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   83e001               | and                 eax, 1

        $sequence_3 = { e8???????? 8d8daffbffff c645fc0a 51 8b08 e8???????? 8b8db4fbffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8daffbffff         | lea                 ecx, [ebp - 0x451]
            //   c645fc0a             | mov                 byte ptr [ebp - 4], 0xa
            //   51                   | push                ecx
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   e8????????           |                     
            //   8b8db4fbffff         | mov                 ecx, dword ptr [ebp - 0x44c]

        $sequence_4 = { 7429 6a08 59 33c0 83ec18 8bfe f3ab }
            // n = 7, score = 100
            //   7429                 | je                  0x2b
            //   6a08                 | push                8
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   83ec18               | sub                 esp, 0x18
            //   8bfe                 | mov                 edi, esi
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_5 = { 894c2414 8d0c28 89442420 8974241c 894c2418 55 7630 }
            // n = 7, score = 100
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   8d0c28               | lea                 ecx, [eax + ebp]
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   8974241c             | mov                 dword ptr [esp + 0x1c], esi
            //   894c2418             | mov                 dword ptr [esp + 0x18], ecx
            //   55                   | push                ebp
            //   7630                 | jbe                 0x32

        $sequence_6 = { e8???????? 83c40c 6b45e430 8945dc 8d80602a4500 8945e4 803800 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6b45e430             | imul                eax, dword ptr [ebp - 0x1c], 0x30
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8d80602a4500         | lea                 eax, [eax + 0x452a60]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   803800               | cmp                 byte ptr [eax], 0

        $sequence_7 = { 85c0 7422 ff75e0 e8???????? ff75e4 e8???????? 53 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7422                 | je                  0x24
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   e8????????           |                     
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_8 = { 0f848a030000 51 51 8bcc 8d45d8 50 8919 }
            // n = 7, score = 100
            //   0f848a030000         | je                  0x390
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   8bcc                 | mov                 ecx, esp
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8919                 | mov                 dword ptr [ecx], ebx

        $sequence_9 = { e8???????? 83c40c 8d85a8fbffff 6a08 50 ff15???????? 85c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85a8fbffff         | lea                 eax, [ebp - 0x458]
            //   6a08                 | push                8
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 734208
}