rule win_turla_rpc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.turla_rpc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.turla_rpc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c785080100003025213c 66c7850c0100003a3b c6850e01000055 c745c007303431 }
            // n = 4, score = 200
            //   c785080100003025213c     | mov    dword ptr [ebp + 0x108], 0x3c212530
            //   66c7850c0100003a3b     | mov    word ptr [ebp + 0x10c], 0x3b3a
            //   c6850e01000055       | mov                 byte ptr [ebp + 0x10e], 0x55
            //   c745c007303431       | mov                 dword ptr [ebp - 0x40], 0x31343007

        $sequence_1 = { 488bd8 ffd3 488d4d70 488bf8 ffd3 }
            // n = 5, score = 200
            //   488bd8               | dec                 eax
            //   ffd3                 | mov                 ebx, eax
            //   488d4d70             | call                ebx
            //   488bf8               | dec                 eax
            //   ffd3                 | lea                 ecx, [ebp + 0x70]

        $sequence_2 = { 660f6f05???????? 66c785ec0000000255 c785a0000000193a3431 c785a4000000193c3727 c785a800000034272c02 f30f7f8568010000 c685ac00000055 }
            // n = 7, score = 200
            //   660f6f05????????     |                     
            //   66c785ec0000000255     | mov    word ptr [ebp + 0xec], 0x5502
            //   c785a0000000193a3431     | mov    dword ptr [ebp + 0xa0], 0x31343a19
            //   c785a4000000193c3727     | mov    dword ptr [ebp + 0xa4], 0x27373c19
            //   c785a800000034272c02     | mov    dword ptr [ebp + 0xa8], 0x22c2734
            //   f30f7f8568010000     | movdqu              xmmword ptr [ebp + 0x168], xmm0
            //   c685ac00000055       | mov                 byte ptr [ebp + 0xac], 0x55

        $sequence_3 = { c785c400000027273a27 c785c8000000183a3130 c685cc00000055 c785c001000030362155 c745d002273c21 c745d430133c39 66c745d83055 }
            // n = 7, score = 200
            //   c785c400000027273a27     | mov    dword ptr [ebp + 0xc4], 0x273a2727
            //   c785c8000000183a3130     | mov    dword ptr [ebp + 0xc8], 0x30313a18
            //   c685cc00000055       | mov                 byte ptr [ebp + 0xcc], 0x55
            //   c785c001000030362155     | mov    dword ptr [ebp + 0x1c0], 0x55213630
            //   c745d002273c21       | mov                 dword ptr [ebp - 0x30], 0x213c2702
            //   c745d430133c39       | mov                 dword ptr [ebp - 0x2c], 0x393c1330
            //   66c745d83055         | mov                 word ptr [ebp - 0x28], 0x5530

        $sequence_4 = { 66c74424543155 c744243033273030 c644243455 c744244033263030 }
            // n = 4, score = 200
            //   66c74424543155       | mov                 word ptr [esp + 0x54], 0x5531
            //   c744243033273030     | mov                 dword ptr [esp + 0x30], 0x30302733
            //   c644243455           | mov                 byte ptr [esp + 0x34], 0x55
            //   c744244033263030     | mov                 dword ptr [esp + 0x40], 0x30302633

        $sequence_5 = { c745b06970746f c745b472536163 66c745b86c00 ff15???????? }
            // n = 4, score = 200
            //   c745b06970746f       | mov                 byte ptr [ebp + 0x148], 0x55
            //   c745b472536163       | mov                 dword ptr [ebp + 0x160], 0x30383c01
            //   66c745b86c00         | mov                 dword ptr [ebp + 0x164], 0x5521203a
            //   ff15????????         |                     

        $sequence_6 = { c7456016273034 c745642130133c c7456839300255 c7851001000016273034 c7851401000021300527 c785180100003a363026 }
            // n = 6, score = 200
            //   c7456016273034       | mov                 dword ptr [ebp + 0x60], 0x34302716
            //   c745642130133c       | mov                 dword ptr [ebp + 0x64], 0x3c133021
            //   c7456839300255       | mov                 dword ptr [ebp + 0x68], 0x55023039
            //   c7851001000016273034     | mov    dword ptr [ebp + 0x110], 0x34302716
            //   c7851401000021300527     | mov    dword ptr [ebp + 0x114], 0x27053021
            //   c785180100003a363026     | mov    dword ptr [ebp + 0x118], 0x2630363a

        $sequence_7 = { f30f7f8d98010000 c785b800000027273a27 c685bc00000055 c685d801000055 }
            // n = 4, score = 200
            //   f30f7f8d98010000     | movdqu              xmmword ptr [ebp + 0x198], xmm1
            //   c785b800000027273a27     | mov    dword ptr [ebp + 0xb8], 0x273a2727
            //   c685bc00000055       | mov                 byte ptr [ebp + 0xbc], 0x55
            //   c685d801000055       | mov                 byte ptr [ebp + 0x1d8], 0x55

        $sequence_8 = { c685d801000055 f30f7f85b0010000 660f6f05???????? c7858000000012302101 c7858400000030382505 }
            // n = 5, score = 200
            //   c685d801000055       | mov                 byte ptr [ebp + 0x1d8], 0x55
            //   f30f7f85b0010000     | movdqu              xmmword ptr [ebp + 0x1b0], xmm0
            //   660f6f05????????     |                     
            //   c7858000000012302101     | mov    dword ptr [ebp + 0x80], 0x1213012
            //   c7858400000030382505     | mov    dword ptr [ebp + 0x84], 0x5253830

        $sequence_9 = { 68???????? 6a00 6a00 ff15???????? 6a00 6aff 68d2040000 }
            // n = 7, score = 100
            //   68????????           |                     
            //   6a00                 | push                eax
            //   6a00                 | test                eax, eax
            //   ff15????????         |                     
            //   6a00                 | jne                 0x89
            //   6aff                 | push                0
            //   68d2040000           | push                0

        $sequence_10 = { c745f474006c00 c785c8feffff14010000 ff15???????? 85c0 750e 50 50 }
            // n = 7, score = 100
            //   c745f474006c00       | push                esi
            //   c785c8feffff14010000     | xor    esi, esi
            //   ff15????????         |                     
            //   85c0                 | push                dword ptr [esi + 0x10017314]
            //   750e                 | mov                 dword ptr [ebp - 0xc], 0x6c0074
            //   50                   | mov                 dword ptr [ebp - 0x138], 0x114
            //   50                   | test                eax, eax

        $sequence_11 = { 8d45bc 50 ff15???????? 85c0 0f8581000000 }
            // n = 5, score = 100
            //   8d45bc               | mov                 dword ptr [ebp - 0x50], 0x6f747069
            //   50                   | mov                 dword ptr [ebp - 0x4c], 0x63615372
            //   ff15????????         |                     
            //   85c0                 | mov                 word ptr [ebp - 0x48], 0x6c
            //   0f8581000000         | lea                 eax, [ebp - 0x44]

        $sequence_12 = { 7514 8d45ac 50 ff15???????? 8bf8 85ff 0f8434010000 }
            // n = 7, score = 100
            //   7514                 | jne                 0x24d9
            //   8d45ac               | mov                 edx, 5
            //   50                   | lea                 ecx, [0x10017010]
            //   ff15????????         |                     
            //   8bf8                 | jne                 0x16
            //   85ff                 | lea                 eax, [ebp - 0x54]
            //   0f8434010000         | push                eax

        $sequence_13 = { 5d c3 6a00 6800000080 6a02 }
            // n = 5, score = 100
            //   5d                   | push                0
            //   c3                   | push                -1
            //   6a00                 | push                0x4d2
            //   6800000080           | pop                 ebp
            //   6a02                 | ret                 

        $sequence_14 = { e8???????? cc 56 33f6 ffb614730110 ff15???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   cc                   | push                0
            //   56                   | push                0x80000000
            //   33f6                 | push                2
            //   ffb614730110         | int3                
            //   ff15????????         |                     

        $sequence_15 = { 833d????????00 0f85d3240000 ba05000000 8d0d10700110 e9???????? }
            // n = 5, score = 100
            //   833d????????00       |                     
            //   0f85d3240000         | jne                 0x12
            //   ba05000000           | push                eax
            //   8d0d10700110         | push                eax
            //   e9????????           |                     

    condition:
        7 of them and filesize < 311296
}