rule win_turla_silentmoon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.turla_silentmoon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.turla_silentmoon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4df4 83c404 51 ffd7 83c404 8d95e4f7ffff }
            // n = 6, score = 300
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   83c404               | add                 esp, 4
            //   51                   | push                ecx
            //   ffd7                 | call                edi
            //   83c404               | add                 esp, 4
            //   8d95e4f7ffff         | lea                 edx, [ebp - 0x81c]

        $sequence_1 = { 7ce0 8b55d4 47 03c9 897dd0 3bfa 7ec7 }
            // n = 7, score = 300
            //   7ce0                 | jl                  0xffffffe2
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   47                   | inc                 edi
            //   03c9                 | add                 ecx, ecx
            //   897dd0               | mov                 dword ptr [ebp - 0x30], edi
            //   3bfa                 | cmp                 edi, edx
            //   7ec7                 | jle                 0xffffffc9

        $sequence_2 = { 41 3b4df0 7ce3 8955d4 83fa11 0f8fe8000000 83f801 }
            // n = 7, score = 300
            //   41                   | inc                 ecx
            //   3b4df0               | cmp                 ecx, dword ptr [ebp - 0x10]
            //   7ce3                 | jl                  0xffffffe5
            //   8955d4               | mov                 dword ptr [ebp - 0x2c], edx
            //   83fa11               | cmp                 edx, 0x11
            //   0f8fe8000000         | jg                  0xee
            //   83f801               | cmp                 eax, 1

        $sequence_3 = { 50 6a01 8d4dff 51 56 c645ffec 895dec }
            // n = 7, score = 300
            //   50                   | push                eax
            //   6a01                 | push                1
            //   8d4dff               | lea                 ecx, [ebp - 1]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   c645ffec             | mov                 byte ptr [ebp - 1], 0xec
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx

        $sequence_4 = { ff15???????? 8b4ddc 8b35???????? 51 ffd6 8b55e0 52 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8b35????????         |                     
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   52                   | push                edx

        $sequence_5 = { 85c0 7407 32c0 5e 8be5 5d c3 }
            // n = 7, score = 300
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   32c0                 | xor                 al, al
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_6 = { 8955fc 8bd9 8975f4 8bc6 8bff 3bc8 7f24 }
            // n = 7, score = 300
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8bd9                 | mov                 ebx, ecx
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   8bc6                 | mov                 eax, esi
            //   8bff                 | mov                 edi, edi
            //   3bc8                 | cmp                 ecx, eax
            //   7f24                 | jg                  0x26

        $sequence_7 = { 09be58020000 8b7df8 898e5c020000 0fb77c7b52 897df4 8b3cba 897dd4 }
            // n = 7, score = 300
            //   09be58020000         | or                  dword ptr [esi + 0x258], edi
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   898e5c020000         | mov                 dword ptr [esi + 0x25c], ecx
            //   0fb77c7b52           | movzx               edi, word ptr [ebx + edi*2 + 0x52]
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi
            //   8b3cba               | mov                 edi, dword ptr [edx + edi*4]
            //   897dd4               | mov                 dword ptr [ebp - 0x2c], edi

        $sequence_8 = { 83f801 752e 8b4508 8b7c245c }
            // n = 4, score = 300
            //   83f801               | cmp                 eax, 1
            //   752e                 | jne                 0x30
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b7c245c             | mov                 edi, dword ptr [esp + 0x5c]

        $sequence_9 = { 5f 8be5 5d c3 8b55fc 6a04 8d4df8 }
            // n = 7, score = 300
            //   5f                   | pop                 edi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   6a04                 | push                4
            //   8d4df8               | lea                 ecx, [ebp - 8]

    condition:
        7 of them and filesize < 204800
}