rule win_typehash_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.typehash."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.typehash"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8380000000 8bc8 8bf0 c1f905 83e61f 8d3c8de03d4100 c1e603 }
            // n = 7, score = 100
            //   0f8380000000         | jae                 0x86
            //   8bc8                 | mov                 ecx, eax
            //   8bf0                 | mov                 esi, eax
            //   c1f905               | sar                 ecx, 5
            //   83e61f               | and                 esi, 0x1f
            //   8d3c8de03d4100       | lea                 edi, [ecx*4 + 0x413de0]
            //   c1e603               | shl                 esi, 3

        $sequence_1 = { 8d7c246c 83c9ff 33c0 8d54246c f2ae f7d1 }
            // n = 6, score = 100
            //   8d7c246c             | lea                 edi, [esp + 0x6c]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   8d54246c             | lea                 edx, [esp + 0x6c]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx

        $sequence_2 = { 8b0c8de03d4100 8d04c1 eb05 b8???????? f6400480 0f8492000000 ff4e04 }
            // n = 7, score = 100
            //   8b0c8de03d4100       | mov                 ecx, dword ptr [ecx*4 + 0x413de0]
            //   8d04c1               | lea                 eax, [ecx + eax*8]
            //   eb05                 | jmp                 7
            //   b8????????           |                     
            //   f6400480             | test                byte ptr [eax + 4], 0x80
            //   0f8492000000         | je                  0x98
            //   ff4e04               | dec                 dword ptr [esi + 4]

        $sequence_3 = { 8b15???????? 8d4c2410 52 6800280000 }
            // n = 4, score = 100
            //   8b15????????         |                     
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   52                   | push                edx
            //   6800280000           | push                0x2800

        $sequence_4 = { 50 c745c458e64000 e8???????? cc 56 ff742408 8bf1 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   c745c458e64000       | mov                 dword ptr [ebp - 0x3c], 0x40e658
            //   e8????????           |                     
            //   cc                   | int3                
            //   56                   | push                esi
            //   ff742408             | push                dword ptr [esp + 8]
            //   8bf1                 | mov                 esi, ecx

        $sequence_5 = { 5f eb26 8d4508 8db6742a4100 6a00 50 }
            // n = 6, score = 100
            //   5f                   | pop                 edi
            //   eb26                 | jmp                 0x28
            //   8d4508               | lea                 eax, [ebp + 8]
            //   8db6742a4100         | lea                 esi, [esi + 0x412a74]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_6 = { c1f905 83e01f 8b0c8de03d4100 8d04c1 }
            // n = 4, score = 100
            //   c1f905               | sar                 ecx, 5
            //   83e01f               | and                 eax, 0x1f
            //   8b0c8de03d4100       | mov                 ecx, dword ptr [ecx*4 + 0x413de0]
            //   8d04c1               | lea                 eax, [ecx + eax*8]

        $sequence_7 = { 3bd7 770f e8???????? 8b442418 8b0d???????? 3bfb }
            // n = 6, score = 100
            //   3bd7                 | cmp                 edx, edi
            //   770f                 | ja                  0x11
            //   e8????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b0d????????         |                     
            //   3bfb                 | cmp                 edi, ebx

        $sequence_8 = { 8d4c2440 c68424cc00000001 e8???????? 8b44241c 3d00280000 7312 }
            // n = 6, score = 100
            //   8d4c2440             | lea                 ecx, [esp + 0x40]
            //   c68424cc00000001     | mov                 byte ptr [esp + 0xcc], 1
            //   e8????????           |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   3d00280000           | cmp                 eax, 0x2800
            //   7312                 | jae                 0x14

        $sequence_9 = { 03f8 897c2410 813f50450000 7413 68c1000000 }
            // n = 5, score = 100
            //   03f8                 | add                 edi, eax
            //   897c2410             | mov                 dword ptr [esp + 0x10], edi
            //   813f50450000         | cmp                 dword ptr [edi], 0x4550
            //   7413                 | je                  0x15
            //   68c1000000           | push                0xc1

    condition:
        7 of them and filesize < 180224
}