rule win_uacme_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.uacme."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.uacme"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45e8 50 ff15???????? 2175f8 8d45f8 50 8d45f0 }
            // n = 7, score = 100
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   2175f8               | and                 dword ptr [ebp - 8], esi
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_1 = { 8d85ecfbffff 50 8d85ccf3ffff 50 }
            // n = 4, score = 100
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   50                   | push                eax
            //   8d85ccf3ffff         | lea                 eax, [ebp - 0xc34]
            //   50                   | push                eax

        $sequence_2 = { 50 8d45b4 50 68???????? ff15???????? 8bf0 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_3 = { 8bcf c60000 40 83e901 75f7 8b1d???????? 394d10 }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   c60000               | mov                 byte ptr [eax], 0
            //   40                   | inc                 eax
            //   83e901               | sub                 ecx, 1
            //   75f7                 | jne                 0xfffffff9
            //   8b1d????????         |                     
            //   394d10               | cmp                 dword ptr [ebp + 0x10], ecx

        $sequence_4 = { ff75f4 53 ff15???????? ff75fc 53 ff15???????? 6807700000 }
            // n = 7, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   6807700000           | push                0x7007

        $sequence_5 = { 83ee01 75f7 68???????? 8d85c8fdffff 50 }
            // n = 5, score = 100
            //   83ee01               | sub                 esi, 1
            //   75f7                 | jne                 0xfffffff9
            //   68????????           |                     
            //   8d85c8fdffff         | lea                 eax, [ebp - 0x238]
            //   50                   | push                eax

        $sequence_6 = { 5d c3 ff7508 8bd3 8d8de0f7ffff e8???????? 59 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bd3                 | mov                 edx, ebx
            //   8d8de0f7ffff         | lea                 ecx, [ebp - 0x820]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_7 = { 8975dc 8975cc 85f6 7421 8b55e0 }
            // n = 5, score = 100
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi
            //   8975cc               | mov                 dword ptr [ebp - 0x34], esi
            //   85f6                 | test                esi, esi
            //   7421                 | je                  0x23
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]

        $sequence_8 = { 8906 5e 8b45fc 8be5 5d c3 55 }
            // n = 7, score = 100
            //   8906                 | mov                 dword ptr [esi], eax
            //   5e                   | pop                 esi
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_9 = { 3db7000000 0f8593010000 ba???????? 8d8ddcfbffff e8???????? 6a00 }
            // n = 6, score = 100
            //   3db7000000           | cmp                 eax, 0xb7
            //   0f8593010000         | jne                 0x199
            //   ba????????           |                     
            //   8d8ddcfbffff         | lea                 ecx, [ebp - 0x424]
            //   e8????????           |                     
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 565248
}