rule win_udpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.udpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.udpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c414 8d55c4 52 ffd7 }
            // n = 4, score = 100
            //   83c414               | add                 esp, 0x14
            //   8d55c4               | lea                 edx, [ebp - 0x3c]
            //   52                   | push                edx
            //   ffd7                 | call                edi

        $sequence_1 = { 53 56 52 ffd7 }
            // n = 4, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   52                   | push                edx
            //   ffd7                 | call                edi

        $sequence_2 = { 83c408 3bf3 7ea8 8b5d08 2bde }
            // n = 5, score = 100
            //   83c408               | add                 esp, 8
            //   3bf3                 | cmp                 esi, ebx
            //   7ea8                 | jle                 0xffffffaa
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   2bde                 | sub                 ebx, esi

        $sequence_3 = { 8985f4feffff 8985f8feffff 3905???????? 7e09 a1???????? 8b30 eb06 }
            // n = 7, score = 100
            //   8985f4feffff         | mov                 dword ptr [ebp - 0x10c], eax
            //   8985f8feffff         | mov                 dword ptr [ebp - 0x108], eax
            //   3905????????         |                     
            //   7e09                 | jle                 0xb
            //   a1????????           |                     
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   eb06                 | jmp                 8

        $sequence_4 = { 7510 c78598feffff01000000 8b9d98feffff 47 83fb01 75b4 85db }
            // n = 7, score = 100
            //   7510                 | jne                 0x12
            //   c78598feffff01000000     | mov    dword ptr [ebp - 0x168], 1
            //   8b9d98feffff         | mov                 ebx, dword ptr [ebp - 0x168]
            //   47                   | inc                 edi
            //   83fb01               | cmp                 ebx, 1
            //   75b4                 | jne                 0xffffffb6
            //   85db                 | test                ebx, ebx

        $sequence_5 = { 8b8110020000 301408 8b9110020000 0fb6140a }
            // n = 4, score = 100
            //   8b8110020000         | mov                 eax, dword ptr [ecx + 0x210]
            //   301408               | xor                 byte ptr [eax + ecx], dl
            //   8b9110020000         | mov                 edx, dword ptr [ecx + 0x210]
            //   0fb6140a             | movzx               edx, byte ptr [edx + ecx]

        $sequence_6 = { 83c40c 57 6a02 ff15???????? 8d8dd0fdffff 8bf0 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   57                   | push                edi
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   8d8dd0fdffff         | lea                 ecx, [ebp - 0x230]
            //   8bf0                 | mov                 esi, eax

        $sequence_7 = { 51 a3???????? e8???????? 83c40c 68ff000000 8d95fcfdffff 52 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   a3????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68ff000000           | push                0xff
            //   8d95fcfdffff         | lea                 edx, [ebp - 0x204]
            //   52                   | push                edx

        $sequence_8 = { 53 e8???????? 83c404 8b95e4fbffff 52 ff15???????? 5b }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b95e4fbffff         | mov                 edx, dword ptr [ebp - 0x41c]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   5b                   | pop                 ebx

        $sequence_9 = { 83e60f 0fb65c35e8 0fb671fd 8858fd }
            // n = 4, score = 100
            //   83e60f               | and                 esi, 0xf
            //   0fb65c35e8           | movzx               ebx, byte ptr [ebp + esi - 0x18]
            //   0fb671fd             | movzx               esi, byte ptr [ecx - 3]
            //   8858fd               | mov                 byte ptr [eax - 3], bl

    condition:
        7 of them and filesize < 163840
}