rule win_ufrstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ufrstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ufrstealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8955f4 3b55f0 0f82ddfcffff 68???????? e8???????? 68???????? }
            // n = 6, score = 200
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   3b55f0               | cmp                 edx, dword ptr [ebp - 0x10]
            //   0f82ddfcffff         | jb                  0xfffffce3
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_1 = { 72f2 eb1e 8b75e8 46 }
            // n = 4, score = 200
            //   72f2                 | jb                  0xfffffff4
            //   eb1e                 | jmp                 0x20
            //   8b75e8               | mov                 esi, dword ptr [ebp - 0x18]
            //   46                   | inc                 esi

        $sequence_2 = { ff35???????? ff15???????? 8bd8 ff75fc ff7608 53 ff15???????? }
            // n = 7, score = 200
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff7608               | push                dword ptr [esi + 8]
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_3 = { 83c304 ebb2 c705????????66666666 6a04 68???????? e8???????? }
            // n = 6, score = 200
            //   83c304               | add                 ebx, 4
            //   ebb2                 | jmp                 0xffffffb4
            //   c705????????66666666     |     
            //   6a04                 | push                4
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_4 = { 85c0 7548 803d????????00 7411 6a00 68???????? ff15???????? }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7548                 | jne                 0x4a
            //   803d????????00       |                     
            //   7411                 | je                  0x13
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_5 = { 6800040000 ff7510 6aff ff7204 6a00 6a00 ff15???????? }
            // n = 7, score = 200
            //   6800040000           | push                0x400
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   6aff                 | push                -1
            //   ff7204               | push                dword ptr [edx + 4]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_6 = { 8945ec ff75f0 ff15???????? 50 6a06 ff75f0 }
            // n = 6, score = 200
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   50                   | push                eax
            //   6a06                 | push                6
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_7 = { 6801000080 ff15???????? 85c0 0f85fc030000 68000000f0 6a01 6a00 }
            // n = 7, score = 200
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85fc030000         | jne                 0x402
            //   68000000f0           | push                0xf0000000
            //   6a01                 | push                1
            //   6a00                 | push                0

        $sequence_8 = { e8???????? 85c0 0f846c020000 83c00a }
            // n = 4, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f846c020000         | je                  0x272
            //   83c00a               | add                 eax, 0xa

        $sequence_9 = { a1???????? 0305???????? c60000 68???????? ff35???????? e8???????? }
            // n = 6, score = 200
            //   a1????????           |                     
            //   0305????????         |                     
            //   c60000               | mov                 byte ptr [eax], 0
            //   68????????           |                     
            //   ff35????????         |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 770048
}