rule win_underminer_ek_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.underminer_ek."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.underminer_ek"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 e8???????? 83c404 53 e8???????? 83c404 8b551c }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b551c               | mov                 edx, dword ptr [ebp + 0x1c]

        $sequence_1 = { 25ffff0000 3d4ee640bb 7404 3bc1 7501 }
            // n = 5, score = 100
            //   25ffff0000           | and                 eax, 0xffff
            //   3d4ee640bb           | cmp                 eax, 0xbb40e64e
            //   7404                 | je                  6
            //   3bc1                 | cmp                 eax, ecx
            //   7501                 | jne                 3

        $sequence_2 = { 83c40c 66394e06 894d10 7630 83c710 8b07 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   66394e06             | cmp                 word ptr [esi + 6], cx
            //   894d10               | mov                 dword ptr [ebp + 0x10], ecx
            //   7630                 | jbe                 0x32
            //   83c710               | add                 edi, 0x10
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_3 = { 03c3 8901 eb18 3daafc0d7c }
            // n = 4, score = 100
            //   03c3                 | add                 eax, ebx
            //   8901                 | mov                 dword ptr [ecx], eax
            //   eb18                 | jmp                 0x1a
            //   3daafc0d7c           | cmp                 eax, 0x7c0dfcaa

        $sequence_4 = { 7463 8b55f4 8b0495582c4300 f644382848 }
            // n = 4, score = 100
            //   7463                 | je                  0x65
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b0495582c4300       | mov                 eax, dword ptr [edx*4 + 0x432c58]
            //   f644382848           | test                byte ptr [eax + edi + 0x28], 0x48

        $sequence_5 = { 8ad0 8adc 88550f 807e0700 7417 0fb6813051fa7e 8a4dff }
            // n = 7, score = 100
            //   8ad0                 | mov                 dl, al
            //   8adc                 | mov                 bl, ah
            //   88550f               | mov                 byte ptr [ebp + 0xf], dl
            //   807e0700             | cmp                 byte ptr [esi + 7], 0
            //   7417                 | je                  0x19
            //   0fb6813051fa7e       | movzx               eax, byte ptr [ecx + 0x7efa5130]
            //   8a4dff               | mov                 cl, byte ptr [ebp - 1]

        $sequence_6 = { 6a06 53 ff7508 53 ff55f0 85c0 7c07 }
            // n = 7, score = 100
            //   6a06                 | push                6
            //   53                   | push                ebx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   ff55f0               | call                dword ptr [ebp - 0x10]
            //   85c0                 | test                eax, eax
            //   7c07                 | jl                  9

        $sequence_7 = { 0f8535010000 83bd88feffff00 0f85a4040000 807d9a01 }
            // n = 4, score = 100
            //   0f8535010000         | jne                 0x13b
            //   83bd88feffff00       | cmp                 dword ptr [ebp - 0x178], 0
            //   0f85a4040000         | jne                 0x4aa
            //   807d9a01             | cmp                 byte ptr [ebp - 0x66], 1

        $sequence_8 = { 885c012e 8b0495582c4300 804c012d04 46 }
            // n = 4, score = 100
            //   885c012e             | mov                 byte ptr [ecx + eax + 0x2e], bl
            //   8b0495582c4300       | mov                 eax, dword ptr [edx*4 + 0x432c58]
            //   804c012d04           | or                  byte ptr [ecx + eax + 0x2d], 4
            //   46                   | inc                 esi

        $sequence_9 = { c745f800000000 0f8444040000 837d3000 0f843a040000 }
            // n = 4, score = 100
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   0f8444040000         | je                  0x44a
            //   837d3000             | cmp                 dword ptr [ebp + 0x30], 0
            //   0f843a040000         | je                  0x440

        $sequence_10 = { 0f8776050000 52 51 e8???????? 83c408 c745c000000000 }
            // n = 6, score = 100
            //   0f8776050000         | ja                  0x57c
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0

        $sequence_11 = { c745fc20000000 eb21 8bd0 83e220 }
            // n = 4, score = 100
            //   c745fc20000000       | mov                 dword ptr [ebp - 4], 0x20
            //   eb21                 | jmp                 0x23
            //   8bd0                 | mov                 edx, eax
            //   83e220               | and                 edx, 0x20

        $sequence_12 = { 3e58 3e7f3e 98 3e4a }
            // n = 4, score = 100
            //   3e58                 | pop                 eax
            //   3e7f3e               | jg                  0x41
            //   98                   | cwde                
            //   3e4a                 | dec                 edx

        $sequence_13 = { 47 8d5101 0f1f8000000000 8a01 41 84c0 }
            // n = 6, score = 100
            //   47                   | inc                 edi
            //   8d5101               | lea                 edx, [ecx + 1]
            //   0f1f8000000000       | nop                 dword ptr [eax]
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   41                   | inc                 ecx
            //   84c0                 | test                al, al

        $sequence_14 = { 66895dc0 ff7508 895dec ab ff760c 895df8 ab }
            // n = 7, score = 100
            //   66895dc0             | mov                 word ptr [ebp - 0x40], bx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_15 = { e8???????? 83c410 eb03 8d041a 5b 5d c3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   eb03                 | jmp                 5
            //   8d041a               | lea                 eax, [edx + ebx]
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 466944
}