rule win_unidentified_013_korean_malware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_013_korean_malware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_013_korean_malware"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6888130000 4f ffd6 e8???????? 85c0 74eb bfb4000000 }
            // n = 7, score = 200
            //   6888130000           | push                0x1388
            //   4f                   | dec                 edi
            //   ffd6                 | call                esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   74eb                 | je                  0xffffffed
            //   bfb4000000           | mov                 edi, 0xb4

        $sequence_1 = { eb20 8d4604 c60000 eb18 8bc2 c604083f 897e14 }
            // n = 7, score = 200
            //   eb20                 | jmp                 0x22
            //   8d4604               | lea                 eax, [esi + 4]
            //   c60000               | mov                 byte ptr [eax], 0
            //   eb18                 | jmp                 0x1a
            //   8bc2                 | mov                 eax, edx
            //   c604083f             | mov                 byte ptr [eax + ecx], 0x3f
            //   897e14               | mov                 dword ptr [esi + 0x14], edi

        $sequence_2 = { e8???????? 8d842454030000 50 83ec1c 8bcc 899c2480060000 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8d842454030000       | lea                 eax, [esp + 0x354]
            //   50                   | push                eax
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   899c2480060000       | mov                 dword ptr [esp + 0x680], ebx

        $sequence_3 = { 837c242401 0f85be000000 0fb6542e04 3bd1 7412 }
            // n = 5, score = 200
            //   837c242401           | cmp                 dword ptr [esp + 0x24], 1
            //   0f85be000000         | jne                 0xc4
            //   0fb6542e04           | movzx               edx, byte ptr [esi + ebp + 4]
            //   3bd1                 | cmp                 edx, ecx
            //   7412                 | je                  0x14

        $sequence_4 = { e8???????? 83c404 837c243410 7221 8b442420 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837c243410           | cmp                 dword ptr [esp + 0x34], 0x10
            //   7221                 | jb                  0x23
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]

        $sequence_5 = { 8b4c2410 51 57 50 8944243c ff15???????? 8bf0 }
            // n = 7, score = 200
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   50                   | push                eax
            //   8944243c             | mov                 dword ptr [esp + 0x3c], eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { e8???????? 81c41c010000 c3 55 6a00 6a00 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   81c41c010000         | add                 esp, 0x11c
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_7 = { 50 8d842458060000 64a300000000 68???????? 68???????? 68???????? }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8d842458060000       | lea                 eax, [esp + 0x658]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_8 = { 8b842420010000 53 56 57 }
            // n = 4, score = 200
            //   8b842420010000       | mov                 eax, dword ptr [esp + 0x120]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_9 = { 395c2440 7304 8d44242c 8a1c38 0fb6cb }
            // n = 5, score = 200
            //   395c2440             | cmp                 dword ptr [esp + 0x40], ebx
            //   7304                 | jae                 6
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   8a1c38               | mov                 bl, byte ptr [eax + edi]
            //   0fb6cb               | movzx               ecx, bl

    condition:
        7 of them and filesize < 204800
}